/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.common.operators;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.common.QueryRow;
import java.util.Collection;
import java.util.List;

final class PhysicalOperatorUtil {
    private PhysicalOperatorUtil() {
    }

    static GenericRow getIntermediateRow(QueryRow row, boolean additionalColumnsNeeded) {
        if (!additionalColumnsNeeded) {
            return row.value();
        }
        GenericKey key = row.key();
        GenericRow value = row.value();
        List keyFields = key.values();
        value.ensureAdditionalCapacity(1 + keyFields.size() + row.window().map(w -> 2).orElse(0));
        value.append((Object)row.rowTime());
        value.appendAll((Collection)keyFields);
        row.window().ifPresent(window -> {
            value.append((Object)window.start().toEpochMilli());
            value.append((Object)window.end().toEpochMilli());
        });
        return value;
    }
}

