/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.common.operators;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.common.QueryRow;
import io.confluent.ksql.execution.common.QueryRowImpl;
import io.confluent.ksql.execution.common.operators.AbstractPhysicalOperator;
import io.confluent.ksql.execution.common.operators.PhysicalOperatorUtil;
import io.confluent.ksql.execution.common.operators.UnaryPhysicalOperator;
import io.confluent.ksql.execution.streams.SqlPredicateFactory;
import io.confluent.ksql.execution.streams.materialization.PullProcessingContext;
import io.confluent.ksql.execution.transform.KsqlProcessingContext;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import io.confluent.ksql.execution.transform.sqlpredicate.SqlPredicate;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.QueryFilterNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SelectOperator
extends AbstractPhysicalOperator
implements UnaryPhysicalOperator {
    private final QueryFilterNode logicalNode;
    private final ProcessingLogger logger;
    private final SqlPredicate predicate;
    private AbstractPhysicalOperator child;
    private KsqlTransformer<Object, Optional<GenericRow>> transformer;

    public SelectOperator(QueryFilterNode logicalNode, ProcessingLogger logger) {
        this(logicalNode, logger, SqlPredicate::new);
    }

    @VisibleForTesting
    SelectOperator(QueryFilterNode logicalNode, ProcessingLogger logger, SqlPredicateFactory predicateFactory) {
        this.logicalNode = Objects.requireNonNull(logicalNode, "logicalNode");
        this.logger = Objects.requireNonNull(logger, "logger");
        this.predicate = predicateFactory.create(logicalNode.getRewrittenPredicate(), logicalNode.getCompiledWhereClause());
    }

    @Override
    public void open() {
        this.transformer = this.predicate.getTransformer(this.logger);
        this.child.open();
    }

    @Override
    public Object next() {
        Optional<Object> result = Optional.empty();
        while (result.equals(Optional.empty())) {
            QueryRow row = (QueryRow)this.child.next();
            if (row == null) {
                return null;
            }
            if (row.getOffsetRange().isPresent()) {
                return row;
            }
            result = this.transformRow(row);
        }
        return result.get();
    }

    private Optional<QueryRow> transformRow(QueryRow queryRow) {
        GenericRow intermediate = PhysicalOperatorUtil.getIntermediateRow(queryRow, this.logicalNode.getAddAdditionalColumnsToIntermediateSchema());
        return ((Optional)this.transformer.transform((Object)queryRow.key(), intermediate, (KsqlProcessingContext)new PullProcessingContext(queryRow.rowTime()))).map(r -> QueryRowImpl.of(this.logicalNode.getIntermediateSchema(), queryRow.key(), queryRow.window(), r, queryRow.rowTime()));
    }

    @Override
    public void close() {
        this.child.close();
    }

    @Override
    public PlanNode getLogicalNode() {
        return this.logicalNode;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public void addChild(AbstractPhysicalOperator child) {
        if (this.child != null) {
            throw new UnsupportedOperationException("The select operator already has a child.");
        }
        Objects.requireNonNull(child, "child");
        this.child = child;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AbstractPhysicalOperator getChild() {
        return this.child;
    }

    @Override
    public AbstractPhysicalOperator getChild(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AbstractPhysicalOperator> getChildren() {
        throw new UnsupportedOperationException();
    }
}

