/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.pull.operators;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.common.QueryRowImpl;
import io.confluent.ksql.execution.common.operators.AbstractPhysicalOperator;
import io.confluent.ksql.execution.common.operators.UnaryPhysicalOperator;
import io.confluent.ksql.execution.pull.operators.DataSourceOperator;
import io.confluent.ksql.execution.streams.materialization.Locator;
import io.confluent.ksql.execution.streams.materialization.Materialization;
import io.confluent.ksql.execution.streams.materialization.WindowedRow;
import io.confluent.ksql.planner.plan.DataSourceNode;
import io.confluent.ksql.planner.plan.KeyConstraint;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.QueryFilterNode;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyedWindowedTableLookupOperator
extends AbstractPhysicalOperator
implements UnaryPhysicalOperator,
DataSourceOperator {
    private static final Logger LOG = LoggerFactory.getLogger(KeyedWindowedTableLookupOperator.class);
    private final Materialization mat;
    private final DataSourceNode logicalNode;
    private final Optional<ConsistencyOffsetVector> consistencyOffsetVector;
    private ImmutableList<Locator.KsqlPartitionLocation> partitionLocations;
    private Iterator<WindowedRow> resultIterator;
    private Iterator<Locator.KsqlKey> keyIterator;
    private Iterator<Locator.KsqlPartitionLocation> partitionLocationIterator;
    private Locator.KsqlPartitionLocation nextLocation;
    private Locator.KsqlKey nextKey;
    private long returnedRows = 0L;

    public KeyedWindowedTableLookupOperator(Materialization mat, DataSourceNode logicalNode, Optional<ConsistencyOffsetVector> consistencyOffsetVector) {
        this.logicalNode = Objects.requireNonNull(logicalNode, "logicalNode");
        this.mat = Objects.requireNonNull(mat, "mat");
        this.consistencyOffsetVector = Objects.requireNonNull(consistencyOffsetVector, "consistencyOffsetVector");
    }

    @Override
    public void open() {
        this.partitionLocationIterator = this.partitionLocations.iterator();
        if (this.partitionLocationIterator.hasNext()) {
            this.nextLocation = this.partitionLocationIterator.next();
            if (!this.nextLocation.getKeys().isPresent()) {
                throw new IllegalStateException("Table windowed queries should be done with keys");
            }
            this.keyIterator = ((Set)this.nextLocation.getKeys().get()).stream().iterator();
            if (this.keyIterator.hasNext()) {
                this.nextKey = this.keyIterator.next();
                this.updateIterator(KeyedWindowedTableLookupOperator.getWindowBounds(this.nextKey));
            }
        }
    }

    @Override
    public Object next() {
        while (!this.resultIterator.hasNext()) {
            if (!this.keyIterator.hasNext()) {
                if (!this.partitionLocationIterator.hasNext()) {
                    return null;
                }
                this.nextLocation = this.partitionLocationIterator.next();
                if (!this.nextLocation.getKeys().isPresent()) {
                    throw new IllegalStateException("Table lookup queries should be done with keys");
                }
                this.keyIterator = ((Set)this.nextLocation.getKeys().get()).iterator();
            }
            this.nextKey = this.keyIterator.next();
            this.updateIterator(KeyedWindowedTableLookupOperator.getWindowBounds(this.nextKey));
        }
        ++this.returnedRows;
        WindowedRow row = this.resultIterator.next();
        return QueryRowImpl.of(row.schema(), row.key(), row.window(), row.value(), row.rowTime());
    }

    private static QueryFilterNode.WindowBounds getWindowBounds(Locator.KsqlKey ksqlKey) {
        if (!(ksqlKey instanceof KeyConstraint)) {
            throw new IllegalStateException(String.format("Table windowed queries should be done with key constraints: %s", ksqlKey.toString()));
        }
        KeyConstraint keyConstraintKey = (KeyConstraint)ksqlKey;
        if (!keyConstraintKey.getWindowBounds().isPresent()) {
            throw new IllegalStateException(String.format("Table windowed queries should be done with window bounds: %s", ksqlKey));
        }
        return keyConstraintKey.getWindowBounds().get();
    }

    @Override
    public void close() {
    }

    @Override
    public PlanNode getLogicalNode() {
        return this.logicalNode;
    }

    @Override
    public void addChild(AbstractPhysicalOperator child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractPhysicalOperator getChild() {
        return null;
    }

    @Override
    public AbstractPhysicalOperator getChild(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AbstractPhysicalOperator> getChildren() {
        throw new UnsupportedOperationException();
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="partitionLocations is ImmutableList")
    public List<Locator.KsqlPartitionLocation> getPartitionLocations() {
        return this.partitionLocations;
    }

    @Override
    public void setPartitionLocations(List<Locator.KsqlPartitionLocation> locations) {
        Objects.requireNonNull(locations, "locations");
        this.partitionLocations = ImmutableList.copyOf(locations);
    }

    @Override
    public long getReturnedRowCount() {
        return this.returnedRows;
    }

    private void updateIterator(QueryFilterNode.WindowBounds windowBounds) {
        this.resultIterator = this.mat.windowed().get(this.nextKey.getKey(), this.nextLocation.getPartition(), windowBounds.getMergedStart(), windowBounds.getMergedEnd(), this.consistencyOffsetVector);
    }
}

