/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.pull.operators;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.common.QueryRowImpl;
import io.confluent.ksql.execution.common.operators.AbstractPhysicalOperator;
import io.confluent.ksql.execution.common.operators.UnaryPhysicalOperator;
import io.confluent.ksql.execution.pull.operators.DataSourceOperator;
import io.confluent.ksql.execution.streams.materialization.Locator;
import io.confluent.ksql.execution.streams.materialization.Materialization;
import io.confluent.ksql.execution.streams.materialization.Row;
import io.confluent.ksql.planner.plan.DataSourceNode;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableScanOperator
extends AbstractPhysicalOperator
implements UnaryPhysicalOperator,
DataSourceOperator {
    private static final Logger LOG = LoggerFactory.getLogger(TableScanOperator.class);
    private final Materialization mat;
    private final DataSourceNode logicalNode;
    private final CompletableFuture<Void> shouldCancelOperations;
    private final Optional<ConsistencyOffsetVector> consistencyOffsetVector;
    private ImmutableList<Locator.KsqlPartitionLocation> partitionLocations;
    private Iterator<Row> resultIterator;
    private Iterator<Locator.KsqlPartitionLocation> partitionLocationIterator;
    private Locator.KsqlPartitionLocation nextLocation;
    private long returnedRows = 0L;

    public TableScanOperator(Materialization mat, DataSourceNode logicalNode, CompletableFuture<Void> shouldCancelOperations, Optional<ConsistencyOffsetVector> consistencyOffsetVector) {
        this.mat = Objects.requireNonNull(mat, "mat");
        this.logicalNode = Objects.requireNonNull(logicalNode, "logicalNode");
        this.shouldCancelOperations = Objects.requireNonNull(shouldCancelOperations, "shouldCancelOperations");
        this.consistencyOffsetVector = Objects.requireNonNull(consistencyOffsetVector, "consistencyOffsetVector");
    }

    @Override
    public void open() {
        this.partitionLocationIterator = this.partitionLocations.iterator();
        if (this.partitionLocationIterator.hasNext()) {
            this.nextLocation = this.partitionLocationIterator.next();
            if (this.nextLocation.getKeys().isPresent()) {
                throw new IllegalStateException("Table scans should not be done with keys");
            }
            this.updateIterator();
        }
    }

    @Override
    public Object next() {
        if (this.shouldCancelOperations.isDone()) {
            return null;
        }
        while (!this.resultIterator.hasNext()) {
            if (!this.partitionLocationIterator.hasNext()) {
                return null;
            }
            this.nextLocation = this.partitionLocationIterator.next();
            if (this.nextLocation.getKeys().isPresent()) {
                throw new IllegalStateException("Table scans should not be done with keys");
            }
            this.updateIterator();
        }
        ++this.returnedRows;
        Row row = this.resultIterator.next();
        return QueryRowImpl.of(row.schema(), row.key(), row.window(), row.value(), row.rowTime());
    }

    @Override
    public void close() {
    }

    @Override
    public PlanNode getLogicalNode() {
        return this.logicalNode;
    }

    @Override
    public void addChild(AbstractPhysicalOperator child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractPhysicalOperator getChild() {
        return null;
    }

    @Override
    public AbstractPhysicalOperator getChild(int index) {
        return null;
    }

    @Override
    public List<AbstractPhysicalOperator> getChildren() {
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="partitionLocations is ImmutableList")
    public List<Locator.KsqlPartitionLocation> getPartitionLocations() {
        return this.partitionLocations;
    }

    @Override
    public void setPartitionLocations(List<Locator.KsqlPartitionLocation> locations) {
        Objects.requireNonNull(locations, "locations");
        this.partitionLocations = ImmutableList.copyOf(locations);
    }

    @Override
    public long getReturnedRowCount() {
        return this.returnedRows;
    }

    private void updateIterator() {
        this.resultIterator = this.mat.nonWindowed().get(this.nextLocation.getPartition(), this.consistencyOffsetVector);
    }
}

