/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.common.QueryRow;
import io.confluent.ksql.execution.common.operators.AbstractPhysicalOperator;
import io.confluent.ksql.execution.pull.PullPhysicalPlan;
import io.confluent.ksql.execution.scalablepush.ScalablePushRegistry;
import io.confluent.ksql.execution.scalablepush.operators.PushDataSourceOperator;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.reactive.BufferedPublisher;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.VertxUtils;
import io.vertx.core.Context;
import java.util.Objects;
import java.util.Optional;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushPhysicalPlan {
    private static final int CAPACITY = Integer.MAX_VALUE;
    private static final Logger LOGGER = LoggerFactory.getLogger(PullPhysicalPlan.class);
    private final AbstractPhysicalOperator root;
    private final LogicalSchema schema;
    private final QueryId queryId;
    private final String catchupConsumerGroupId;
    private final ScalablePushRegistry scalablePushRegistry;
    private final PushDataSourceOperator dataSourceOperator;
    private final Context context;
    private final KsqlConstants.QuerySourceType querySourceType;
    private volatile boolean closed = false;
    private long timer = -1L;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public PushPhysicalPlan(AbstractPhysicalOperator root, LogicalSchema schema, QueryId queryId, String catchupConsumerGroupId, ScalablePushRegistry scalablePushRegistry, PushDataSourceOperator dataSourceOperator, Context context, KsqlConstants.QuerySourceType querySourceType) {
        this.root = Objects.requireNonNull(root, "root");
        this.schema = Objects.requireNonNull(schema, "schema");
        this.queryId = Objects.requireNonNull(queryId, "queryId");
        this.catchupConsumerGroupId = Objects.requireNonNull(catchupConsumerGroupId, "catchupConsumerGroupId");
        this.scalablePushRegistry = Objects.requireNonNull(scalablePushRegistry, "scalablePushRegistry");
        this.dataSourceOperator = dataSourceOperator;
        this.context = Objects.requireNonNull(context, "context");
        this.querySourceType = Objects.requireNonNull(querySourceType, "querySourceType");
    }

    public BufferedPublisher<QueryRow> execute() {
        return this.subscribeAndExecute(Optional.empty());
    }

    BufferedPublisher<QueryRow> subscribeAndExecute(Optional<Subscriber<QueryRow>> subscriber) {
        Publisher publisher = new Publisher(this.context);
        subscriber.ifPresent(arg_0 -> ((Publisher)publisher).subscribe(arg_0));
        this.context.runOnContext(v -> this.open(publisher));
        return publisher;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void maybeNext(Publisher publisher) {
        QueryRow row;
        while (!this.isErrored(publisher) && (row = (QueryRow)this.next(publisher)) != null) {
            publisher.accept(row);
        }
        if (publisher.isFailed()) {
            return;
        }
        if (!this.closed) {
            if (this.timer >= 0L) {
                this.context.owner().cancelTimer(this.timer);
            }
            this.timer = this.context.owner().setTimer(100L, timerId -> this.context.runOnContext(v -> this.maybeNext(publisher)));
        } else {
            publisher.close();
        }
    }

    private boolean isErrored(Publisher publisher) {
        if (this.dataSourceOperator.droppedRows()) {
            this.closeInternal();
            publisher.reportDroppedRows();
            return true;
        }
        if (this.dataSourceOperator.hasError()) {
            this.closeInternal();
            publisher.reportHasError();
            return true;
        }
        return false;
    }

    private void open(Publisher publisher) {
        VertxUtils.checkContext((Context)this.context);
        try {
            this.dataSourceOperator.setNewRowCallback(() -> this.context.runOnContext(v -> this.maybeNext(publisher)));
            this.root.open();
            this.maybeNext(publisher);
        }
        catch (Throwable t) {
            publisher.sendException(t);
        }
    }

    private Object next(Publisher publisher) {
        VertxUtils.checkContext((Context)this.context);
        try {
            return this.root.next();
        }
        catch (Throwable t) {
            publisher.sendException(t);
            return null;
        }
    }

    public void close() {
        this.context.runOnContext(v -> this.closeInternal());
    }

    private void closeInternal() {
        VertxUtils.checkContext((Context)this.context);
        if (!this.closed) {
            this.closed = true;
            this.root.close();
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AbstractPhysicalOperator getRoot() {
        return this.root;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public LogicalSchema getOutputSchema() {
        return this.schema;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public ScalablePushRegistry getScalablePushRegistry() {
        return this.scalablePushRegistry;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Context getContext() {
        return this.context;
    }

    public KsqlConstants.QuerySourceType getSourceType() {
        return this.querySourceType;
    }

    public long getRowsReadFromDataSource() {
        return this.dataSourceOperator.getRowsReadCount();
    }

    public String getCatchupConsumerGroupId() {
        return this.catchupConsumerGroupId;
    }

    public static class Publisher
    extends BufferedPublisher<QueryRow> {
        public Publisher(Context ctx) {
            super(ctx, Integer.MAX_VALUE);
        }

        public void reportDroppedRows() {
            this.sendError(new RuntimeException("Dropped rows"));
        }

        public void reportHasError() {
            this.sendError(new RuntimeException("Internal error occurred"));
        }

        public void sendException(Throwable e) {
            this.sendError(e);
        }

        public boolean isFailed() {
            return super.isFailed();
        }
    }
}

