/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush.consumer;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.execution.scalablepush.consumer.CatchupCoordinator;
import java.time.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatchupCoordinatorImpl
implements CatchupCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(CatchupCoordinatorImpl.class);
    private static final long WAIT_TIME_MS = 10000L;
    private final Clock clock;
    private int catchupJoiners = 0;
    private boolean latestWaiting = false;

    public CatchupCoordinatorImpl() {
        this(Clock.systemUTC());
    }

    public CatchupCoordinatorImpl(Clock clock) {
        this.clock = clock;
    }

    @Override
    public synchronized void checkShouldWaitForCatchup() {
        long startTime = this.clock.millis();
        while (this.catchupJoiners > 0) {
            try {
                this.latestWaiting = true;
                LOG.info("Waiting for Catchups to join Latest consumer, current count {}", (Object)this.catchupJoiners);
                this.wait(10000L);
                long waitedMs = this.clock.millis() - startTime;
                LOG.info("Waited for Catchups to join Latest consumer for {}ms and current count {}", (Object)waitedMs, (Object)this.catchupJoiners);
                if (waitedMs < 10000L) continue;
                break;
            }
            catch (InterruptedException e) {
                LOG.error("Caught InterruptedException during catchup waiting", (Throwable)e);
                Thread.currentThread().interrupt();
                throw new RuntimeException("InterruptedException during catchup waiting", e);
            }
        }
        this.latestWaiting = false;
    }

    @Override
    public synchronized boolean checkShouldCatchUp(AtomicBoolean signalledLatest, Function<Boolean, Boolean> isCaughtUp, Runnable switchOver) {
        if (this.latestWaiting && isCaughtUp.apply(false).booleanValue()) {
            LOG.info("Catchup is joining latest, about to decrement {}", (Object)this.catchupJoiners);
            if (signalledLatest.get()) {
                signalledLatest.set(false);
                --this.catchupJoiners;
                this.notify();
            }
            switchOver.run();
            return true;
        }
        if (!signalledLatest.get() && isCaughtUp.apply(true).booleanValue()) {
            LOG.info("Signalling Latest, about to increment {}", (Object)this.catchupJoiners);
            signalledLatest.set(true);
            ++this.catchupJoiners;
        }
        return false;
    }

    @Override
    public synchronized void catchupIsClosing(AtomicBoolean signalledLatest) {
        if (signalledLatest.get()) {
            signalledLatest.set(false);
            --this.catchupJoiners;
        }
    }

    @VisibleForTesting
    public synchronized void simulateWaitingInTest() {
        if (this.catchupJoiners > 0) {
            this.latestWaiting = true;
        }
    }
}

