/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush.consumer;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.scalablepush.consumer.CatchupCoordinator;
import io.confluent.ksql.execution.scalablepush.consumer.ScalablePushConsumer;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConfig;
import java.time.Clock;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatestConsumer
extends ScalablePushConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(LatestConsumer.class);
    private final CatchupCoordinator catchupCoordinator;
    private final Consumer<Collection<TopicPartition>> catchupAssignmentUpdater;
    private final KsqlConfig ksqlConfig;
    private boolean gotFirstAssignment = false;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public LatestConsumer(String topicName, boolean windowed, LogicalSchema logicalSchema, KafkaConsumer<Object, GenericRow> consumer, CatchupCoordinator catchupCoordinator, Consumer<Collection<TopicPartition>> catchupAssignmentUpdater, KsqlConfig ksqlConfig, Clock clock) {
        super(topicName, windowed, logicalSchema, consumer, clock);
        this.catchupCoordinator = catchupCoordinator;
        this.catchupAssignmentUpdater = catchupAssignmentUpdater;
        this.ksqlConfig = ksqlConfig;
    }

    @Override
    protected void subscribeOrAssign() {
        try {
            Thread.sleep(this.ksqlConfig.getLong("ksql.query.push.v2.new.latest.delay.ms"));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Got interrupted", e);
        }
        this.consumer.subscribe((Collection)ImmutableList.of((Object)this.topicName), new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> collection) {
                LOG.info("Latest consumer had partitions revoked {}", collection);
                LatestConsumer.this.newAssignment(null);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> collection) {
                LOG.info("Latest consumer had partitions assigned {}", collection);
                if (collection == null) {
                    return;
                }
                LatestConsumer.this.newAssignment(collection);
                LatestConsumer.this.updateCurrentPositions();
                LatestConsumer.this.catchupAssignmentUpdater.accept(collection);
                if (!LatestConsumer.this.gotFirstAssignment) {
                    LatestConsumer.this.maybeSeekToEnd();
                }
                LatestConsumer.this.gotFirstAssignment = true;
            }
        });
    }

    @Override
    protected void onEmptyRecords() {
        this.catchupCoordinator.checkShouldWaitForCatchup();
    }

    @Override
    protected void afterBatchProcessed() {
        this.catchupCoordinator.checkShouldWaitForCatchup();
    }

    @Override
    protected void onNewAssignment() {
    }

    private void maybeSeekToEnd() {
        Set topicPartitions = (Set)this.topicPartitions.get();
        long maxAge = this.ksqlConfig.getLong("ksql.query.push.v2.latest.reset.age.ms");
        long timeMs = this.clock.millis() - maxAge;
        HashMap<TopicPartition, Long> timestamps = new HashMap<TopicPartition, Long>();
        for (TopicPartition tp : topicPartitions) {
            timestamps.put(tp, timeMs);
        }
        Map offsetAndTimestampMap = this.consumer.offsetsForTimes(timestamps);
        Map offsetAndMetadataMap = this.consumer.committed(topicPartitions);
        LOG.info("Latest maybe seeking to end offsetAndTimestampMap {}, offsetAndMetadataMap {}", (Object)offsetAndTimestampMap, (Object)offsetAndMetadataMap);
        boolean foundAtLeastOneRecent = false;
        for (Map.Entry entry : offsetAndTimestampMap.entrySet()) {
            OffsetAndMetadata metadata = (OffsetAndMetadata)offsetAndMetadataMap.get(entry.getKey());
            if (metadata == null || entry.getValue() == null || ((OffsetAndTimestamp)entry.getValue()).offset() > metadata.offset()) continue;
            foundAtLeastOneRecent = true;
        }
        if (!foundAtLeastOneRecent) {
            this.consumer.seekToEnd((Collection)topicPartitions);
            this.updateCurrentPositions();
            LOG.info("LatestConsumer seeking to end {}", (Object)this.currentPositions);
        }
    }

    public static interface LatestConsumerFactory {
        public LatestConsumer create(String var1, boolean var2, LogicalSchema var3, KafkaConsumer<Object, GenericRow> var4, CatchupCoordinator var5, Consumer<Collection<TopicPartition>> var6, KsqlConfig var7, Clock var8);
    }
}

