/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush.locator;

import io.confluent.ksql.execution.scalablepush.locator.PushLocator;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.streams.StreamsMetadata;
import org.apache.kafka.streams.state.HostInfo;

public class AllHostsLocator
implements PushLocator {
    private final Supplier<List<PersistentQueryMetadata>> allPersistentQueries;
    private final URL localhost;

    public AllHostsLocator(Supplier<List<PersistentQueryMetadata>> allPersistentQueries, URL localhost) {
        this.allPersistentQueries = allPersistentQueries;
        try {
            this.localhost = new URL(localhost.toString());
        }
        catch (MalformedURLException fatalError) {
            throw new IllegalStateException("Could not deep copy URL: " + localhost);
        }
    }

    @Override
    public List<PushLocator.KsqlNode> locate() {
        List<PersistentQueryMetadata> currentQueries = this.allPersistentQueries.get();
        if (currentQueries.isEmpty()) {
            return Collections.emptyList();
        }
        return currentQueries.stream().map(QueryMetadata::getAllStreamsHostMetadata).filter(Objects::nonNull).flatMap(Collection::stream).map(StreamsMetadata::hostInfo).map(hi -> new Node(this.isLocalhost((HostInfo)hi), this.buildLocation((HostInfo)hi))).distinct().collect(Collectors.toList());
    }

    private boolean isLocalhost(HostInfo hostInfo) {
        if (hostInfo.port() != this.localhost.getPort()) {
            return false;
        }
        return hostInfo.host().equalsIgnoreCase(this.localhost.getHost()) || hostInfo.host().equalsIgnoreCase("localhost");
    }

    private URI buildLocation(HostInfo remoteInfo) {
        try {
            return new URL(this.localhost.getProtocol(), remoteInfo.host(), remoteInfo.port(), "/").toURI();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert remote host info to URL. remoteInfo: " + remoteInfo);
        }
    }

    private static class Node
    implements PushLocator.KsqlNode {
        private final boolean isLocal;
        private final URI location;

        Node(boolean isLocal, URI location) {
            this.isLocal = isLocal;
            this.location = location;
        }

        @Override
        public boolean isLocal() {
            return this.isLocal;
        }

        @Override
        public URI location() {
            return this.location;
        }

        public String toString() {
            return "Node{isLocal = " + this.isLocal + ", location = " + this.location + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node that = (Node)o;
            return this.isLocal == that.isLocal && this.location.equals(that.location);
        }

        public int hashCode() {
            return Objects.hash(this.isLocal, this.location);
        }
    }
}

