/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.execution.function.UdfUtil;
import io.confluent.ksql.function.DynamicFunctionInvoker;
import io.confluent.ksql.function.FunctionInvoker;
import io.confluent.ksql.function.GenericsUtil;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.ParameterInfo;
import io.confluent.ksql.function.SchemaProvider;
import io.confluent.ksql.function.types.LambdaType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.ParamTypes;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.UdfSchemaProvider;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.SqlTypeParser;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.security.ExtensionSecurityManager;
import io.confluent.ksql.util.KsqlException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class FunctionLoaderUtils {
    private FunctionLoaderUtils() {
    }

    static List<ParameterInfo> createParameters(Method method, String functionName, SqlTypeParser typeParser) {
        return IntStream.range(0, method.getParameterCount()).mapToObj(idx -> {
            Type type = method.getGenericParameterTypes()[idx];
            Optional<UdfParameter> annotation = Arrays.stream(method.getParameterAnnotations()[idx]).filter(UdfParameter.class::isInstance).map(UdfParameter.class::cast).findAny();
            Parameter param = method.getParameters()[idx];
            String name = annotation.map(UdfParameter::value).filter(val -> !val.isEmpty()).orElse(param.isNamePresent() ? param.getName() : "");
            if (name.trim().isEmpty()) {
                throw new KsqlFunctionException(String.format("Cannot resolve parameter name for param at index %d for UDF %s:%s. Please specify a name in @UdfParameter or compile your JAR with -parameters to infer the name from the parameter name.", idx, functionName, method.getName()));
            }
            ParamType paramType = annotation.isPresent() && !annotation.get().schema().isEmpty() ? SchemaConverters.sqlToFunctionConverter().toFunctionType(typeParser.parse(annotation.get().schema()).getSqlType()) : UdfUtil.getSchemaFromType((Type)type);
            String doc = annotation.map(UdfParameter::description).orElse("");
            boolean isVariadicParam = idx == method.getParameterCount() - 1 && method.isVarArgs();
            return new ParameterInfo(name, paramType, doc, isVariadicParam);
        }).collect(Collectors.toList());
    }

    @VisibleForTesting
    public static FunctionInvoker createFunctionInvoker(Method method) {
        return new DynamicFunctionInvoker(method);
    }

    static Object instantiateFunctionInstance(Class functionClass, String functionName) {
        try {
            return functionClass.newInstance();
        }
        catch (Exception e) {
            throw new KsqlException("Failed to create instance for UDF/UDTF=" + functionName, (Throwable)e);
        }
    }

    static ParamType getReturnType(Method method, String annotationSchema, SqlTypeParser typeParser) {
        return FunctionLoaderUtils.getReturnType(method, method.getGenericReturnType(), annotationSchema, typeParser);
    }

    static ParamType getReturnType(Method method, Type type, String annotationSchema, SqlTypeParser typeParser) {
        try {
            return annotationSchema.isEmpty() ? UdfUtil.getSchemaFromType((Type)type) : SchemaConverters.sqlToFunctionConverter().toFunctionType(typeParser.parse(annotationSchema).getSqlType());
        }
        catch (KsqlException e) {
            throw new KsqlException("Could not load UDF method with signature: " + method, (Throwable)e);
        }
    }

    static SchemaProvider handleUdfReturnSchema(Class theClass, ParamType javaReturnSchema, String annotationSchema, SqlTypeParser parser, String schemaProviderFunctionName, String functionName, boolean isVariadic) {
        Function<List<SqlArgument>, SqlType> schemaProvider;
        if (!"".equals(schemaProviderFunctionName)) {
            schemaProvider = FunctionLoaderUtils.handleUdfSchemaProviderAnnotation(schemaProviderFunctionName, theClass, functionName);
        } else if (!"".equals(annotationSchema)) {
            SqlType sqlType = parser.parse(annotationSchema).getSqlType();
            schemaProvider = args -> sqlType;
        } else if (!GenericsUtil.hasGenerics((ParamType)javaReturnSchema)) {
            SqlType sqlType = FunctionLoaderUtils.fromJavaType(javaReturnSchema, functionName);
            schemaProvider = args -> sqlType;
        } else {
            schemaProvider = null;
        }
        return (parameters, arguments) -> {
            if (schemaProvider != null) {
                SqlType returnType = (SqlType)schemaProvider.apply(arguments);
                if (!ParamTypes.areCompatible((SqlArgument)SqlArgument.of((SqlType)returnType), (ParamType)javaReturnSchema, (boolean)false)) {
                    throw new KsqlException(String.format("Return type %s of UDF %s does not match the declared return type %s.", returnType, functionName.toUpperCase(), SchemaConverters.functionToSqlConverter().toSqlType(javaReturnSchema)));
                }
                return returnType;
            }
            HashMap genericMapping = new HashMap();
            for (int i = 0; i < Math.min(parameters.size(), arguments.size()); ++i) {
                ParamType schema = (ParamType)parameters.get(i);
                if (schema instanceof LambdaType) {
                    if (isVariadic && i == parameters.size() - 1) {
                        throw new KsqlException(String.format("Lambda function %s cannot be variadic.", ((SqlArgument)arguments.get(i)).toString()));
                    }
                    genericMapping.putAll(GenericsUtil.reserveGenerics((ParamType)schema, (SqlArgument)((SqlArgument)arguments.get(i))));
                    continue;
                }
                SqlType instance = isVariadic && i == parameters.size() - 1 ? SqlTypes.array((SqlType)((SqlArgument)arguments.get(i)).getSqlTypeOrThrow()) : ((SqlArgument)arguments.get(i)).getSqlTypeOrThrow();
                genericMapping.putAll(GenericsUtil.reserveGenerics((ParamType)schema, (SqlArgument)SqlArgument.of((SqlType)instance)));
            }
            return GenericsUtil.applyResolved((ParamType)javaReturnSchema, genericMapping);
        };
    }

    private static SqlType fromJavaType(ParamType javaReturnSchema, String functionName) {
        try {
            return SchemaConverters.functionToSqlConverter().toSqlType(javaReturnSchema);
        }
        catch (Exception e) {
            throw new KsqlException("Cannot load UDF " + functionName + ". " + javaReturnSchema + " return type is not supported without an explicit schema or schema provider set in the method annotation.");
        }
    }

    private static Function<List<SqlArgument>, SqlType> handleUdfSchemaProviderAnnotation(String schemaProviderName, Class theClass, String functionName) {
        Method m = FunctionLoaderUtils.findSchemaProvider(theClass, schemaProviderName);
        Object instance = FunctionLoaderUtils.instantiateFunctionInstance(theClass, functionName);
        return parameterSchemas -> FunctionLoaderUtils.invokeSchemaProviderMethod(instance, m, parameterSchemas, functionName);
    }

    private static Method findSchemaProvider(Class<?> theClass, String schemaProviderName) {
        try {
            Method m = theClass.getDeclaredMethod(schemaProviderName, List.class);
            if (!m.isAnnotationPresent(UdfSchemaProvider.class)) {
                throw new KsqlException(String.format("Method %s should be annotated with @UdfSchemaProvider.", schemaProviderName));
            }
            return m;
        }
        catch (NoSuchMethodException e) {
            throw new KsqlException(String.format("Cannot find schema provider method with name %s and parameter List<SqlType> in class %s.", schemaProviderName, theClass.getName()), (Throwable)e);
        }
    }

    private static SqlType invokeSchemaProviderMethod(Object instance, Method m, List<SqlArgument> args, String functionName) {
        try {
            ExtensionSecurityManager.INSTANCE.pushInUdf();
            SqlType sqlType = (SqlType)m.invoke(instance, args);
            return sqlType;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new KsqlException(String.format("Cannot invoke the schema provider method %s for UDF %s. ", m.getName(), functionName), (Throwable)e);
        }
        finally {
            ExtensionSecurityManager.INSTANCE.popOutUdf();
        }
    }
}

