/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.function.BaseAggregateFunction;
import io.confluent.ksql.function.FunctionMetrics;
import io.confluent.ksql.function.ParameterInfo;
import io.confluent.ksql.function.udaf.Udaf;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.security.ExtensionSecurityManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.kstream.Merger;

public class UdafAggregateFunction<I, A, O>
extends BaseAggregateFunction<I, A, O> {
    protected final Optional<Sensor> aggregateSensor;
    protected final Optional<Sensor> mapSensor;
    protected final Optional<Sensor> mergeSensor;
    protected final Udaf<I, A, O> udaf;

    protected UdafAggregateFunction(String functionName, List<Integer> udafIndices, Udaf<I, A, O> udaf, SqlType aggregateType, SqlType outputType, List<ParameterInfo> arguments, String description, Optional<Metrics> metrics, String method, int numColArgs) {
        super(functionName, udafIndices, () -> udaf.initialize(), aggregateType, outputType, arguments, description, numColArgs);
        this.udaf = Objects.requireNonNull(udaf, "udaf");
        String groupName = String.format("ksql-udaf-%s-%s", functionName, method);
        this.aggregateSensor = UdafAggregateFunction.getSensor(metrics, functionName, method, groupName, "aggregate");
        this.mapSensor = UdafAggregateFunction.getSensor(metrics, functionName, method, groupName, "map");
        this.mergeSensor = UdafAggregateFunction.getSensor(metrics, functionName, method, groupName, "merge");
    }

    public A aggregate(I currentValue, A aggregateValue) {
        return (A)UdafAggregateFunction.timed(this.aggregateSensor, () -> this.udaf.aggregate(currentValue, aggregateValue));
    }

    public Merger<GenericKey, A> getMerger() {
        return (key, v1, v2) -> UdafAggregateFunction.timed(this.mergeSensor, () -> this.udaf.merge(v1, v2));
    }

    public Function<A, O> getResultMapper() {
        return v1 -> UdafAggregateFunction.timed(this.mapSensor, () -> this.udaf.map(v1));
    }

    private static Optional<Sensor> getSensor(Optional<Metrics> maybeMetrics, String name, String method, String groupName, String step) {
        String sensorName;
        if (!maybeMetrics.isPresent()) {
            return Optional.empty();
        }
        Metrics metrics = maybeMetrics.get();
        Sensor existing = metrics.getSensor(sensorName = step + "-" + name + "-" + method);
        if (existing != null) {
            return Optional.of(existing);
        }
        Sensor newSensor = FunctionMetrics.getInvocationSensor(metrics, sensorName, groupName, name + " " + method + " udaf's " + step + " step");
        return Optional.of(newSensor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T timed(Optional<Sensor> maybeSensor, Supplier<T> task) {
        long start = Time.SYSTEM.nanoseconds();
        try {
            ExtensionSecurityManager.INSTANCE.pushInUdf();
            T t = task.get();
            return t;
        }
        finally {
            maybeSensor.ifPresent(sensor -> sensor.record((double)(Time.SYSTEM.nanoseconds() - start)));
            ExtensionSecurityManager.INSTANCE.popOutUdf();
        }
    }
}

