/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.function.AggregateFunctionFactory;
import io.confluent.ksql.function.MutableFunctionRegistry;
import io.confluent.ksql.function.UdafAggregateFunctionFactory;
import io.confluent.ksql.function.UdafFactoryInvoker;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;
import io.confluent.ksql.function.udf.UdfMetadata;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.schema.ksql.SqlTypeParser;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdafLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdafLoader.class);
    private final MutableFunctionRegistry functionRegistry;
    private final Optional<Metrics> metrics;
    private final SqlTypeParser typeParser;

    public UdafLoader(MutableFunctionRegistry functionRegistry, Optional<Metrics> metrics, SqlTypeParser typeParser) {
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.metrics = Objects.requireNonNull(metrics, "metrics");
        this.typeParser = Objects.requireNonNull(typeParser, "typeParser");
    }

    public void loadUdafFromClass(Class<?> theClass, String path) {
        UdafDescription udafAnnotation = theClass.getAnnotation(UdafDescription.class);
        ArrayList<UdafFactoryInvoker> invokers = new ArrayList<UdafFactoryInvoker>();
        for (Method method : theClass.getMethods()) {
            if (method.getAnnotation(UdafFactory.class) == null) continue;
            if (!Modifier.isStatic(method.getModifiers())) {
                LOGGER.warn("Trying to create a UDAF from a non-static factory method. Udaf factory methods must be static. class={}, method={}, name={}", new Object[]{method.getDeclaringClass(), method.getName(), udafAnnotation.name()});
                continue;
            }
            UdafFactory annotation = method.getAnnotation(UdafFactory.class);
            try {
                LOGGER.debug("Adding UDAF name={} from path={} class={}", new Object[]{udafAnnotation.name(), path, method.getDeclaringClass()});
                UdafFactoryInvoker invoker = this.createUdafFactoryInvoker(method, FunctionName.of((String)udafAnnotation.name()), annotation.description(), annotation.paramSchema(), annotation.aggregateSchema(), annotation.returnSchema());
                invokers.add(invoker);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create UDAF name={}, method={}, class={}, path={}", new Object[]{udafAnnotation.name(), method.getName(), method.getDeclaringClass(), path, e});
            }
        }
        this.functionRegistry.addAggregateFunctionFactory((AggregateFunctionFactory)new UdafAggregateFunctionFactory(new UdfMetadata(udafAnnotation.name(), udafAnnotation.description(), udafAnnotation.author(), udafAnnotation.version(), udafAnnotation.category(), path), invokers));
    }

    UdafFactoryInvoker createUdafFactoryInvoker(Method method, FunctionName functionName, String description, String[] inputSchemas, String aggregateSchema, String outputSchema) {
        return new UdafFactoryInvoker(method, functionName, description, inputSchemas, aggregateSchema, outputSchema, this.typeParser, this.metrics);
    }
}

