/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.count;

import io.confluent.ksql.function.udaf.TableUdaf;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;

@UdafDescription(name="COUNT", description="Counts records by key.", author="Confluent")
public class CountKudaf<T>
implements TableUdaf<T, Long, Long> {
    public static final String DESCRIPTION = "Counts records by key.";

    @UdafFactory(description="Counts records by key.")
    public static <T> TableUdaf<T, Long, Long> createCount() {
        return new CountKudaf<T>();
    }

    public Long aggregate(Object currentValue, Long aggregateValue) {
        if (currentValue == null) {
            return aggregateValue;
        }
        return aggregateValue + 1L;
    }

    public Long initialize() {
        return 0L;
    }

    public Long merge(Long aggOne, Long aggTwo) {
        return aggOne + aggTwo;
    }

    public Long map(Long agg) {
        return agg;
    }

    public Long undo(T valueToUndo, Long aggregateValue) {
        if (valueToUndo == null) {
            return aggregateValue;
        }
        return aggregateValue - 1L;
    }
}

