/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.min;

import io.confluent.ksql.function.udaf.BaseComparableKudaf;
import io.confluent.ksql.function.udaf.Udaf;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

@UdafDescription(name="MIN", description="Computes the minimum value for a key.", author="Confluent")
public class MinKudaf<T extends Comparable<? super T>>
extends BaseComparableKudaf<T> {
    @UdafFactory(description="Computes the minimum value for an integer key.")
    public static Udaf<Integer, Integer, Integer> createMinInt() {
        return new MinKudaf<Integer>();
    }

    @UdafFactory(description="Computes the minimum value for a long key.")
    public static Udaf<Long, Long, Long> createMinLong() {
        return new MinKudaf<Long>();
    }

    @UdafFactory(description="Computes the minimum value for a double key.")
    public static Udaf<Double, Double, Double> createMinDouble() {
        return new MinKudaf<Double>();
    }

    @UdafFactory(description="Computes the minimum value for a decimal key.")
    public static Udaf<BigDecimal, BigDecimal, BigDecimal> createMinDecimal() {
        return new MinKudaf<BigDecimal>();
    }

    @UdafFactory(description="Computes the minimum value for a date key.")
    public static Udaf<Date, Date, Date> createMinDate() {
        return new MinKudaf<Date>();
    }

    @UdafFactory(description="Computes the minimum value for a time key.")
    public static Udaf<Time, Time, Time> createMinTime() {
        return new MinKudaf<Time>();
    }

    @UdafFactory(description="Computes the minimum value for a timestamp key.")
    public static Udaf<Timestamp, Timestamp, Timestamp> createMinTimestamp() {
        return new MinKudaf<Timestamp>();
    }

    @UdafFactory(description="Computes the minimum value for a string key.")
    public static Udaf<String, String, String> createMinString() {
        return new MinKudaf<String>();
    }

    @UdafFactory(description="Computes the minimum value for a bytes key.")
    public static Udaf<ByteBuffer, ByteBuffer, ByteBuffer> createMinBytes() {
        return new MinKudaf<ByteBuffer>();
    }

    public MinKudaf() {
        super((first, second) -> first.compareTo(second) > 0 ? second : first);
    }
}

