/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.topkdistinct;

import io.confluent.ksql.function.udaf.Udaf;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

@UdafDescription(name="TOPKDISTINCT", description="Computes the top k distinct values for a column, per key.", author="Confluent")
public class TopkDistinctKudaf<T extends Comparable<? super T>>
implements Udaf<T, List<T>, List<T>> {
    private final int tkVal;
    private SqlType inputType;

    @UdafFactory(description="Calculates the top k distinct values for an integer column, per key.")
    public static Udaf<Integer, List<Integer>, List<Integer>> createTopKDistinctInt(int k) {
        return new TopkDistinctKudaf<Integer>(k);
    }

    @UdafFactory(description="Calculates the top k distinct values for a long column, per key.")
    public static Udaf<Long, List<Long>, List<Long>> createTopKDistinctLong(int k) {
        return new TopkDistinctKudaf<Long>(k);
    }

    @UdafFactory(description="Calculates the top k distinct values for a double column, per key.")
    public static Udaf<Double, List<Double>, List<Double>> createTopKDistinctDouble(int k) {
        return new TopkDistinctKudaf<Double>(k);
    }

    @UdafFactory(description="Calculates the top k distinct values for a string column, per key.")
    public static Udaf<String, List<String>, List<String>> createTopKDistinctString(int k) {
        return new TopkDistinctKudaf<String>(k);
    }

    @UdafFactory(description="Calculates the top k distinct values for a decimal column, per key.")
    public static Udaf<BigDecimal, List<BigDecimal>, List<BigDecimal>> createTopKDistinctDecimal(int k) {
        return new TopkDistinctKudaf<BigDecimal>(k);
    }

    @UdafFactory(description="Calculates the top k distinct values for a date column, per key.")
    public static Udaf<Date, List<Date>, List<Date>> createTopKDistinctDate(int k) {
        return new TopkDistinctKudaf<Date>(k);
    }

    @UdafFactory(description="Calculates the top k distinct values for a time column, per key.")
    public static Udaf<Time, List<Time>, List<Time>> createTopKDistinctTime(int k) {
        return new TopkDistinctKudaf<Time>(k);
    }

    @UdafFactory(description="Calculates the top k distinct values for a timestamp column, per key.")
    public static Udaf<Timestamp, List<Timestamp>, List<Timestamp>> createTopKDistinctTimestamp(int k) {
        return new TopkDistinctKudaf<Timestamp>(k);
    }

    @UdafFactory(description="Calculates the top k distinct values for a bytes column, per key.")
    public static Udaf<ByteBuffer, List<ByteBuffer>, List<ByteBuffer>> createTopKDistinctBytes(int k) {
        return new TopkDistinctKudaf<ByteBuffer>(k);
    }

    TopkDistinctKudaf(int tkVal) {
        this.tkVal = tkVal;
    }

    public void initializeTypeArguments(List<SqlArgument> argTypeList) {
        this.inputType = argTypeList.get(0).getSqlTypeOrThrow();
    }

    public Optional<SqlType> getAggregateSqlType() {
        return Optional.of(SqlArray.of((SqlType)this.inputType));
    }

    public Optional<SqlType> getReturnSqlType() {
        return Optional.of(SqlArray.of((SqlType)this.inputType));
    }

    public List<T> initialize() {
        return new ArrayList();
    }

    public List<T> aggregate(T currentValue, List<T> aggregateValue) {
        if (currentValue == null) {
            return aggregateValue;
        }
        int currentSize = aggregateValue.size();
        if (currentSize == this.tkVal && currentValue.compareTo(aggregateValue.get(currentSize - 1)) <= 0) {
            return aggregateValue;
        }
        if (aggregateValue.contains(currentValue)) {
            return aggregateValue;
        }
        if (currentSize == this.tkVal) {
            aggregateValue.set(currentSize - 1, currentValue);
        } else {
            aggregateValue.add(currentValue);
        }
        aggregateValue.sort(Comparator.reverseOrder());
        return aggregateValue;
    }

    public List<T> merge(List<T> aggOne, List<T> aggTwo) {
        ArrayList<Comparable> merged = new ArrayList<Comparable>(Math.min(this.tkVal, aggOne.size() + aggTwo.size()));
        int idx1 = 0;
        int idx2 = 0;
        for (int i = 0; i != this.tkVal; ++i) {
            Comparable v1 = (Comparable)TopkDistinctKudaf.getNextItem(aggOne, idx1);
            Comparable v2 = (Comparable)TopkDistinctKudaf.getNextItem(aggTwo, idx2);
            if (v1 == null && v2 == null) break;
            if (v1 != null && (v2 == null || v1.compareTo(v2) > 0)) {
                merged.add(v1);
                ++idx1;
                continue;
            }
            if (v1 == null || v2.compareTo(v1) > 0) {
                merged.add(v2);
                ++idx2;
                continue;
            }
            if (v1.compareTo(v2) != 0) continue;
            merged.add(v1);
            ++idx1;
            ++idx2;
        }
        return merged;
    }

    public List<T> map(List<T> agg) {
        return agg;
    }

    private static <T> T getNextItem(List<T> aggList, int idx) {
        return idx < aggList.size() ? (T)aggList.get(idx) : null;
    }
}

