/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.array;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

@UdfDescription(name="array_except", category="ARRAY", description="Returns an array of all the elements in an array except for those also present in a second array. The order of entries in the first array is preserved although any duplicates are removed. Returns NULL if either input is NULL.")
public class ArrayExcept {
    @Udf
    public <T> List<T> except(@UdfParameter(description="Array of values") List<T> left, @UdfParameter(description="Array of exceptions") List<T> right) {
        if (left == null || right == null) {
            return null;
        }
        HashSet distinctRightValues = new HashSet(right);
        LinkedHashSet<T> distinctLeftValues = new LinkedHashSet<T>(left);
        return distinctLeftValues.stream().filter(e -> !distinctRightValues.contains(e)).collect(Collectors.toList());
    }
}

