/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutionException;

@UdfDescription(name="format_timestamp", category="DATE / TIME", author="Confluent", description="Converts a TIMESTAMP value into the string representation of the timestamp in the given format.")
public class FormatTimestamp {
    private final LoadingCache<String, DateTimeFormatter> formatters = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(DateTimeFormatter::ofPattern));

    @Udf(description="Converts a TIMESTAMP value into the string representation of the timestamp in the given format. Single quotes in the timestamp format can be escaped with '', for example: 'yyyy-MM-dd''T''HH:mm:ssX' The system default time zone is used when no time zone is explicitly provided. The format pattern should be in the format expected by java.time.format.DateTimeFormatter")
    public String formatTimestamp(@UdfParameter(description="TIMESTAMP value.") Timestamp timestamp, @UdfParameter(description="The format pattern should be in the format expected by java.time.format.DateTimeFormatter.") String formatPattern) {
        return this.formatTimestamp(timestamp, formatPattern, ZoneId.of("GMT").getId());
    }

    @Udf(description="Converts a TIMESTAMP value into the string representation of the timestamp in the given format. Single quotes in the timestamp format can be escaped with '', for example: 'yyyy-MM-dd''T''HH:mm:ssX'")
    public String formatTimestamp(@UdfParameter(description="TIMESTAMP value.") Timestamp timestamp, @UdfParameter(description="The format pattern should be in the format expected by java.time.format.DateTimeFormatter.") String formatPattern, @UdfParameter(description=" timeZone is a java.util.TimeZone ID format, for example: \"UTC\", \"America/Los_Angeles\", \"PST\", \"Europe/London\"") String timeZone) {
        if (timestamp == null || formatPattern == null || timeZone == null) {
            return null;
        }
        try {
            DateTimeFormatter formatter = (DateTimeFormatter)this.formatters.get((Object)formatPattern);
            ZoneId zoneId = ZoneId.of(timeZone);
            return timestamp.toInstant().atZone(zoneId).format(formatter);
        }
        catch (RuntimeException | ExecutionException e) {
            throw new KsqlFunctionException("Failed to format timestamp " + timestamp + " at timeZone '" + timeZone + "' with formatter '" + formatPattern + "': " + e.getMessage(), (Throwable)e);
        }
    }
}

