/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.sql.Timestamp;

@UdfDescription(name="from_unixtime", category="DATE / TIME", description="Converts the number of milliseconds since 1970-01-01 00:00:00 UTC/GMT into a TIMESTAMP value.", author="Confluent")
public class FromUnixTime {
    @Udf(description="Converts the number of milliseconds since 1970-01-01 00:00:00 UTC/GMT into a TIMESTAMP value.")
    public Timestamp fromUnixTime(@UdfParameter(description="Milliseconds since January 1, 1970, 00:00:00 GMT.") Long epochMilli) {
        if (epochMilli == null) {
            return null;
        }
        return new Timestamp(epochMilli);
    }
}

