/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.sql.Date;
import java.text.ParseException;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.FastDateFormat;

@UdfDescription(name="parse_date", category="DATE / TIME", author="Confluent", description="Converts a string representation of a date in the given format into a DATE value. The format pattern should be in the format expected by java.text.SimpleDateFormat")
public class ParseDate {
    private static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    private final LoadingCache<String, FastDateFormat> formatters = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(pattern -> FastDateFormat.getInstance((String)pattern, (TimeZone)TimeZone.getTimeZone("GMT"))));

    @Udf(description="Converts a string representation of a date in the given format into a DATE value.")
    public Date parseDate(@UdfParameter(description="The string representation of a date.") String formattedDate, @UdfParameter(description="The format pattern should be in the format expected by java.text.SimpleDateFormat.") String formatPattern) {
        if (formattedDate == null || formatPattern == null) {
            return null;
        }
        try {
            long time = ((FastDateFormat)this.formatters.get((Object)formatPattern)).parse(formattedDate).getTime();
            if (time % MILLIS_IN_DAY != 0L) {
                throw new KsqlFunctionException("Date format contains time field.");
            }
            return new Date(time);
        }
        catch (RuntimeException | ParseException | ExecutionException e) {
            throw new KsqlFunctionException("Failed to parse date '" + formattedDate + "' with formatter '" + formatPattern + "': " + e.getMessage(), (Throwable)e);
        }
    }
}

