/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.util.timestamp.StringToTimestampParser;
import java.time.ZoneId;
import java.util.concurrent.ExecutionException;

@UdfDescription(name="stringtotimestamp", category="DATE / TIME", author="Confluent", description="Converts a string representation of a date in the given format into the number of milliseconds since 1970-01-01 00:00:00 UTC/GMT. The system default time zone is used when no time zone is explicitly provided.")
public class StringToTimestamp {
    private final LoadingCache<String, StringToTimestampParser> parsers = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(StringToTimestampParser::new));

    @Udf(description="Converts a string representation of a date in the given format into the number of milliseconds since 1970-01-01 00:00:00 UTC/GMT. Single quotes in the timestamp format can be escaped with '', for example: 'yyyy-MM-dd''T''HH:mm:ssX'. The system default time zone is used when no time zone is explicitly provided.")
    public long stringToTimestamp(@UdfParameter(description="The string representation of a date.") String formattedTimestamp, @UdfParameter(description="The format pattern should be in the format expected by java.time.format.DateTimeFormatter.") String formatPattern) {
        try {
            StringToTimestampParser timestampParser = (StringToTimestampParser)this.parsers.get((Object)formatPattern);
            return timestampParser.parse(formattedTimestamp);
        }
        catch (RuntimeException | ExecutionException e) {
            throw new KsqlFunctionException("Failed to parse timestamp '" + formattedTimestamp + "' with formatter '" + formatPattern + "': " + e.getMessage(), (Throwable)e);
        }
    }

    @Udf(description="Converts a string representation of a date at the given time zone into the number of milliseconds since 1970-01-01 00:00:00 UTC/GMT. Single quotes in the timestamp format can be escaped with '', for example: 'yyyy-MM-dd''T''HH:mm:ssX'.")
    public long stringToTimestamp(@UdfParameter(description="The string representation of a date.") String formattedTimestamp, @UdfParameter(description="The format pattern should be in the format expected by java.time.format.DateTimeFormatter.") String formatPattern, @UdfParameter(description=" timeZone is a java.util.TimeZone ID format, for example: \"UTC\", \"America/Los_Angeles\", \"PST\", \"Europe/London\"") String timeZone) {
        try {
            StringToTimestampParser timestampParser = (StringToTimestampParser)this.parsers.get((Object)formatPattern);
            ZoneId zoneId = ZoneId.of(timeZone);
            return timestampParser.parse(formattedTimestamp, zoneId);
        }
        catch (RuntimeException | ExecutionException e) {
            throw new KsqlFunctionException("Failed to parse timestamp '" + formattedTimestamp + "' at timezone '" + timeZone + "' with formatter '" + formatPattern + "': " + e.getMessage(), (Throwable)e);
        }
    }
}

