/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.json.UdfJsonMapper;
import java.util.HashMap;
import java.util.Map;

@UdfDescription(name="JSON_RECORDS", category="JSON", description="Given a string, parses it as a JSON object and returns a map representing the top-level keys and values. Returns `NULL` if the string can't be interpreted as a JSON object, i.e. it is `NULL` or it does not contain valid JSON, or the JSON value is not an object.", author="Confluent")
public class JsonRecords {
    @Udf
    public Map<String, String> records(@UdfParameter String jsonObj) {
        if (jsonObj == null) {
            return null;
        }
        JsonNode node = UdfJsonMapper.parseJson(jsonObj);
        if (node.isMissingNode() || !node.isObject()) {
            return null;
        }
        HashMap<String, String> ret = new HashMap<String, String>(node.size());
        node.fieldNames().forEachRemaining(k -> {
            JsonNode value = node.get(k);
            if (value instanceof TextNode) {
                ret.put((String)k, value.textValue());
            } else {
                ret.put((String)k, value.toString());
            }
        });
        return ret;
    }
}

