/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="atan2", category="MATHEMATICAL", author="Confluent", description="The inverse (arc) tangent of y / x. This is equivalent to the angle theta when Cartesian coordinates (x, y) are converted to polar coordinates (radius, theta). The returned value is in radians.")
public class Atan2 {
    @Udf(description="Returns the inverse (arc) tangent of y / x")
    public Double atan2(@UdfParameter(value="y", description="The ordinate (y) coordinate.") Integer y, @UdfParameter(value="x", description="The abscissa (x) coordinate.") Integer x) {
        return this.atan2(y == null ? null : Double.valueOf(y.doubleValue()), x == null ? null : Double.valueOf(x.doubleValue()));
    }

    @Udf(description="Returns the inverse (arc) tangent of y / x")
    public Double atan2(@UdfParameter(value="y", description="The ordinate (y) coordinate.") Long y, @UdfParameter(value="x", description="The abscissa (x) coordinate.") Long x) {
        return this.atan2(y == null ? null : Double.valueOf(y.doubleValue()), x == null ? null : Double.valueOf(x.doubleValue()));
    }

    @Udf(description="Returns the inverse (arc) tangent of y / x")
    public Double atan2(@UdfParameter(value="y", description="The ordinate (y) coordinate.") Double y, @UdfParameter(value="x", description="The abscissa (x) coordinate.") Double x) {
        return x == null || y == null ? null : Double.valueOf(Math.atan2(y, x));
    }
}

