/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

@UdfDescription(name="encode", author="Confluent", category="STRING", description="Takes an input string s, which is encoded as input_encoding, and encodes it as output_encoding. The accepted input and output encodings are: hex, utf8, ascii and base64. Throws exception if provided encodings are not supported.")
public class Encode {
    private static final ImmutableMap<String, Encoder> ENCODER_MAP = new ImmutableMap.Builder().put((Object)"hexascii", (Object)new HexToAscii()).put((Object)"hexutf8", (Object)new HexToUtf8()).put((Object)"hexbase64", (Object)new HexToBase64()).put((Object)"utf8ascii", (Object)new Utf8ToAscii()).put((Object)"utf8hex", (Object)new Utf8ToHex()).put((Object)"utf8base64", (Object)new Utf8ToBase64()).put((Object)"asciiutf8", (Object)new AsciiToUtf8()).put((Object)"asciihex", (Object)new AsciiToHex()).put((Object)"asciibase64", (Object)new AsciiToBase64()).put((Object)"base64ascii", (Object)new Base64ToAscii()).put((Object)"base64utf8", (Object)new Base64ToUtf8()).put((Object)"base64hex", (Object)new Base64ToHex()).build();

    @Udf(description="Returns a new string encoded using the outputEncoding ")
    public String encode(@UdfParameter(description="The source string. If null, then function returns null.") String str, @UdfParameter(description="The input encoding. If null, then function returns null.") String inputEncoding, @UdfParameter(description="The output encoding. If null, then function returns null.") String outputEncoding) {
        if (str == null || inputEncoding == null || outputEncoding == null) {
            return null;
        }
        String encodedString = inputEncoding.toLowerCase() + outputEncoding.toLowerCase();
        Encoder encoder = (Encoder)ENCODER_MAP.get((Object)encodedString);
        if (encoder == null) {
            throw new KsqlFunctionException("Supported input and output encodings are: hex, utf8, ascii and base64");
        }
        return encoder.apply(str);
    }

    public static String hexStrip(String hexString) {
        int hexLen = hexString.length();
        if (hexString.matches("0x.*")) {
            return hexLen % 2 != 0 ? "0" + hexString.substring(2) : hexString.substring(2);
        }
        if (hexString.matches("([xX])'.*'")) {
            return hexString.substring(2, hexLen - 1);
        }
        return hexString;
    }

    static class Base64ToAscii
    implements Encoder {
        Base64ToAscii() {
        }

        @Override
        public String apply(String input) throws KsqlFunctionException {
            byte[] decodedB64 = Base64.decodeBase64((String)input);
            return new String(decodedB64, StandardCharsets.US_ASCII);
        }
    }

    static class Base64ToUtf8
    implements Encoder {
        Base64ToUtf8() {
        }

        @Override
        public String apply(String input) throws KsqlFunctionException {
            byte[] decodedB64 = Base64.decodeBase64((String)input);
            return new String(decodedB64, StandardCharsets.UTF_8);
        }
    }

    static class Base64ToHex
    implements Encoder {
        Base64ToHex() {
        }

        @Override
        public String apply(String input) throws KsqlFunctionException {
            byte[] decodedB64 = Base64.decodeBase64((String)input);
            char[] encodedHex = Hex.encodeHex((byte[])decodedB64);
            return new String(encodedHex);
        }
    }

    static class Utf8ToBase64
    implements Encoder {
        Utf8ToBase64() {
        }

        @Override
        public String apply(String input) {
            byte[] encodedB64 = Base64.encodeBase64((byte[])input.getBytes(StandardCharsets.UTF_8));
            return new String(encodedB64, StandardCharsets.UTF_8);
        }
    }

    static class Utf8ToHex
    implements Encoder {
        Utf8ToHex() {
        }

        @Override
        public String apply(String input) {
            char[] encodeHex = Hex.encodeHex((byte[])input.getBytes(StandardCharsets.UTF_8));
            return new String(encodeHex);
        }
    }

    static class Utf8ToAscii
    implements Encoder {
        Utf8ToAscii() {
        }

        @Override
        public String apply(String input) {
            byte[] decoded = input.getBytes(StandardCharsets.UTF_8);
            return new String(decoded, StandardCharsets.US_ASCII);
        }
    }

    static class AsciiToUtf8
    implements Encoder {
        AsciiToUtf8() {
        }

        @Override
        public String apply(String input) {
            byte[] decoded = input.getBytes(StandardCharsets.US_ASCII);
            return new String(decoded, StandardCharsets.UTF_8);
        }
    }

    static class AsciiToBase64
    implements Encoder {
        AsciiToBase64() {
        }

        @Override
        public String apply(String input) {
            byte[] encodedB64 = Base64.encodeBase64((byte[])input.getBytes(StandardCharsets.US_ASCII));
            return new String(encodedB64, StandardCharsets.UTF_8);
        }
    }

    static class AsciiToHex
    implements Encoder {
        AsciiToHex() {
        }

        @Override
        public String apply(String input) {
            return Hex.encodeHexString((byte[])input.getBytes(StandardCharsets.US_ASCII));
        }
    }

    static class HexToUtf8
    implements Encoder {
        HexToUtf8() {
        }

        @Override
        public String apply(String input) throws KsqlFunctionException {
            byte[] decodedHex;
            String processedInput = Encode.hexStrip(input);
            try {
                decodedHex = Hex.decodeHex((String)processedInput);
            }
            catch (DecoderException e) {
                throw new KsqlFunctionException(e.getMessage());
            }
            return new String(decodedHex, StandardCharsets.UTF_8);
        }
    }

    static class HexToBase64
    implements Encoder {
        HexToBase64() {
        }

        @Override
        public String apply(String input) throws KsqlFunctionException {
            byte[] decodedHex;
            String processedInput = Encode.hexStrip(input);
            try {
                decodedHex = Hex.decodeHex((String)processedInput);
            }
            catch (DecoderException e) {
                throw new KsqlFunctionException(e.getMessage());
            }
            byte[] encodedB64 = Base64.encodeBase64((byte[])decodedHex);
            return new String(encodedB64, StandardCharsets.UTF_8);
        }
    }

    static class HexToAscii
    implements Encoder {
        HexToAscii() {
        }

        @Override
        public String apply(String input) {
            try {
                String processedInput = Encode.hexStrip(input);
                byte[] decoded = Hex.decodeHex((String)processedInput);
                return new String(decoded, StandardCharsets.US_ASCII);
            }
            catch (DecoderException e) {
                throw new KsqlFunctionException(e.getMessage());
            }
        }
    }

    static interface Encoder {
        public String apply(String var1) throws KsqlFunctionException;
    }
}

