/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.string.Masker;

@UdfDescription(name="mask", category="STRING", author="Confluent", description="Returns a version of the input string with every character replaced by a mask. Default masking rules will replace all upper-case characters with 'X', all lower-case characters with 'x', all digits with 'n', and any other character with '-'.")
public class Mask {
    @Udf(description="Returns a masked version of the input string. All characters of the input will be replaced according to the default masking rules.")
    public String mask(@UdfParameter(value="input STRING to be masked") String input) {
        return Mask.doMask(new Masker(), input);
    }

    @Udf(description="Returns a masked version of the input string. All characters of the input will be replaced with the specified masking characters")
    public String mask(@UdfParameter(value="input STRING to be masked") String input, @UdfParameter(value="upper-case mask, or NULL to use default") String upper, @UdfParameter(value="lower-case mask, or NULL to use default") String lower, @UdfParameter(value="digit mask, or NULL to use default") String digit, @UdfParameter(value="mask for other characters, or NULL to use default") String other) {
        int upperMask = Masker.getMaskCharacter(upper);
        int lowerMask = Masker.getMaskCharacter(lower);
        int digitMask = Masker.getMaskCharacter(digit);
        int otherMask = Masker.getMaskCharacter(other);
        Masker masker = new Masker(upperMask, lowerMask, digitMask, otherMask);
        return Mask.doMask(masker, input);
    }

    private static String doMask(Masker masker, String input) {
        if (input == null) {
            return null;
        }
        return masker.mask(input);
    }
}

