/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.string.Masker;

@UdfDescription(name="mask_keep_left", category="STRING", author="Confluent", description="Returns a version of the input string with all but the specified number of left-most characters masked out. Default masking rules will replace all upper-case characters with 'X', all lower-case characters with 'x', all digits with 'n', and any other character with '-'.")
public class MaskKeepLeft {
    protected static final String NAME = "mask_keep_left";

    @Udf(description="Returns a masked version of the input string. All characters except for the first n will be replaced according to the default masking rules.")
    public String mask(@UdfParameter(value="input STRING to be masked") String input, @UdfParameter(value="number of characters to keep unmasked at the start") int numChars) {
        return MaskKeepLeft.doMask(new Masker(), input, numChars);
    }

    @Udf(description="Returns a masked version of the input string. All characters except for the first n will be replaced with the specified masking characters")
    public String mask(@UdfParameter(value="input STRING to be masked") String input, @UdfParameter(value="number of characters to keep unmasked at the start") int numChars, @UdfParameter(value="upper-case mask, or NULL to use default") String upper, @UdfParameter(value="lower-case mask, or NULL to use default") String lower, @UdfParameter(value="digit mask, or NULL to use default") String digit, @UdfParameter(value="mask for other characters, or NULL to use default") String other) {
        int upperMask = Masker.getMaskCharacter(upper);
        int lowerMask = Masker.getMaskCharacter(lower);
        int digitMask = Masker.getMaskCharacter(digit);
        int otherMask = Masker.getMaskCharacter(other);
        Masker masker = new Masker(upperMask, lowerMask, digitMask, otherMask);
        return MaskKeepLeft.doMask(masker, input, numChars);
    }

    private static String doMask(Masker masker, String input, int numChars) {
        Masker.validateParams(NAME, numChars);
        if (input == null) {
            return null;
        }
        StringBuilder output = new StringBuilder(input.length());
        int charsToKeep = Math.min(numChars, input.length());
        output.append(input, 0, charsToKeep);
        output.append(masker.mask(input.substring(charsToKeep)));
        return output.toString();
    }
}

