/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UdfDescription(name="regexp_extract", category="REGULAR EXPRESSION", author="Confluent", description="extract the first subtring matched by a regex pattern")
public class RegexpExtract {
    @Udf(description="Returns first substring of the input that matches the given regex pattern")
    public String regexpExtract(@UdfParameter(description="The regex pattern") String pattern, @UdfParameter(description="The input string to apply regex on") String input) {
        return this.regexpExtract(pattern, input, 0);
    }

    @Udf(description="Returns the first substring of the input that matches the regex pattern and the capturing group number specified")
    public String regexpExtract(@UdfParameter(description="The regex pattern") String pattern, @UdfParameter(description="The input string to apply regex on") String input, @UdfParameter(description="The capturing group number") Integer group) {
        if (pattern == null || input == null || group == null) {
            return null;
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(input);
        if (group > m.groupCount()) {
            return null;
        }
        return m.find() ? m.group(group) : null;
    }
}

