/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.url;

import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

@UdfDescription(name="url_decode_param", category="URL", description="Decodes a previously encoded application/x-www-form-urlencoded String", author="Confluent")
public class UrlDecodeParam {
    @Udf
    public String decodeParam(@UdfParameter(description="the value to decode") String input) {
        if (input == null) {
            return null;
        }
        try {
            return URLDecoder.decode(input, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new KsqlFunctionException("url_decode udf encountered an encoding exception while decoding: " + input, (Throwable)e);
        }
    }
}

