/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.url;

import io.confluent.ksql.function.KsqlFunctionException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;

final class UrlParser {
    private UrlParser() {
    }

    static <T> T extract(String url, @Nonnull Function<URI, T> extract) {
        Objects.requireNonNull(extract, "must supply a non-null extract method!");
        if (url == null) {
            return null;
        }
        try {
            return extract.apply(new URI(url));
        }
        catch (URISyntaxException e) {
            throw new KsqlFunctionException("URL input has invalid syntax: " + url, (Throwable)e);
        }
    }
}

