/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udtf;

import io.confluent.ksql.function.udtf.Udtf;
import io.confluent.ksql.function.udtf.UdtfDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@UdtfDescription(name="cube_explode", category="TABLE", author="Confluent", description="Takes as argument a list of columns and outputs all possible combinations of them. It produces 2^d new rows where d is the number of columns given as parameter. Duplicate entries for columns with null value are skipped.")
public class Cube {
    @Udtf
    public <T> List<List<T>> cube(List<T> columns) {
        if (columns == null) {
            return Collections.emptyList();
        }
        return this.createAllCombinations(columns);
    }

    private <T> List<List<T>> createAllCombinations(List<T> columns) {
        int combinations = 1 << columns.size();
        int nullMask = 0;
        for (int i = 0; i < columns.size(); ++i) {
            if (columns.get(i) == null) continue;
            nullMask |= 1 << columns.size() - 1 - i;
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>(combinations);
        for (int bitMask = 0; bitMask <= combinations - 1; ++bitMask) {
            int canonicalBitMask = bitMask & nullMask;
            if (canonicalBitMask != bitMask) continue;
            ArrayList<Object> row = new ArrayList<Object>(columns.size());
            for (int i = 0; i < columns.size(); ++i) {
                row.add(0, (bitMask & 1 << i) == 0 ? null : (Object)columns.get(columns.size() - 1 - i));
            }
            result.add(row);
        }
        return result;
    }
}

