/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.internal;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.kafka.common.metrics.MeasurableStat;

public final class KsqlMetric {
    private final String name;
    private final String description;
    private final Supplier<MeasurableStat> statSupplier;

    public static KsqlMetric of(String name, String description, Supplier<MeasurableStat> statSupplier) {
        return new KsqlMetric(name, description, statSupplier);
    }

    private KsqlMetric(String name, String description, Supplier<MeasurableStat> statSupplier) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.description = Objects.requireNonNull(description, "description cannot be null");
        this.statSupplier = Objects.requireNonNull(statSupplier, "statSupplier cannot be null");
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Supplier<MeasurableStat> statSupplier() {
        return this.statSupplier;
    }
}

