/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.internal;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.internal.JmxDataPointsReporter;
import io.confluent.ksql.internal.MetricsReporter;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakedResourcesMetrics
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeakedResourcesMetrics.class);
    private final KsqlEngine engine;
    private final MetricsReporter reporter;
    private final Map<String, String> customTags;
    private final Supplier<Instant> time;

    public LeakedResourcesMetrics(KsqlEngine ksqlEngine, JmxDataPointsReporter jmxDataPointsReporter, Map<String, String> customTags) {
        this(Instant::now, ksqlEngine, jmxDataPointsReporter, customTags);
    }

    LeakedResourcesMetrics(Supplier<Instant> time, KsqlEngine ksqlEngine, JmxDataPointsReporter jmxDataPointsReporter, Map<String, String> customTags) {
        this.time = Objects.requireNonNull(time, "time");
        this.engine = Objects.requireNonNull(ksqlEngine, "ksqlEngine");
        this.reporter = Objects.requireNonNull(jmxDataPointsReporter, "jmxDataPointsReporter");
        this.customTags = Objects.requireNonNull(customTags, "customTags");
    }

    @Override
    public void run() {
        Instant now = this.time.get();
        try {
            int numLeakedTopics = this.engine.reportNumberOfLeakedTopics();
            int numLeakedStateDirs = this.engine.reportNumberOfLeakedStateDirs();
            int numLeakedTopicsAfterCleanup = this.engine.reportNumLeakedTopicsAfterCleanup();
            int numLeakedStateDirsAfterCleanup = this.engine.reportNumLeakedStateDirsAfterCleanup();
            this.reportLeakedResources(now, numLeakedTopics, numLeakedStateDirs, numLeakedTopicsAfterCleanup, numLeakedStateDirsAfterCleanup);
        }
        catch (RuntimeException e) {
            LOGGER.error("Error collecting leaked resources metrics", (Throwable)e);
            throw e;
        }
    }

    private void reportLeakedResources(Instant now, int numLeakedTopics, int numLeakedStateDirs, int numLeakedTopicsAfterCleanup, int numLeakedStateDirsAfterCleanup) {
        this.reportNumLeakedTopics(now, numLeakedTopics);
        this.reportNumLeakedStateDirs(now, numLeakedStateDirs);
        this.reportNumLeakedTopicsAfterCleanup(now, numLeakedTopicsAfterCleanup);
        this.reportNumLeakedStateDirsAfterCleanup(now, numLeakedStateDirsAfterCleanup);
    }

    private void reportNumLeakedTopics(Instant now, int numLeakedTopics) {
        LOGGER.info("Reporting number of leaked topics: {}", (Object)numLeakedTopics);
        this.reporter.report((List<MetricsReporter.DataPoint>)ImmutableList.of((Object)new MetricsReporter.DataPoint(now, "leaked-topics", numLeakedTopics, this.customTags)));
    }

    private void reportNumLeakedStateDirs(Instant now, int numLeakedStateDirs) {
        LOGGER.info("Reporting number of leaked state files: {}", (Object)numLeakedStateDirs);
        this.reporter.report((List<MetricsReporter.DataPoint>)ImmutableList.of((Object)new MetricsReporter.DataPoint(now, "leaked-state-dirs", numLeakedStateDirs, this.customTags)));
    }

    private void reportNumLeakedTopicsAfterCleanup(Instant now, int numLeakedTopicsAfterCleanup) {
        LOGGER.info("Reporting number of leaked topics after cleanup: {}", (Object)numLeakedTopicsAfterCleanup);
        this.reporter.report((List<MetricsReporter.DataPoint>)ImmutableList.of((Object)new MetricsReporter.DataPoint(now, "leaked-topics-after-cleanup", numLeakedTopicsAfterCleanup, this.customTags)));
    }

    private void reportNumLeakedStateDirsAfterCleanup(Instant now, int numLeakedStateDirsAfterCleanup) {
        LOGGER.info("Reporting number of leaked state directories after cleanup: {}", (Object)numLeakedStateDirsAfterCleanup);
        this.reporter.report((List<MetricsReporter.DataPoint>)ImmutableList.of((Object)new MetricsReporter.DataPoint(now, "leaked-state-dirs-after-cleanup", numLeakedStateDirsAfterCleanup, this.customTags)));
    }
}

