/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.internal;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.common.Configurable;
import java.io.Closeable;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface MetricsReporter
extends Closeable,
Configurable {
    public void report(List<DataPoint> var1);

    public void cleanup(String var1, Map<String, String> var2);

    public static class DataPoint {
        private final String name;
        private final Instant time;
        private final Object value;
        private final ImmutableMap<String, String> tags;

        public DataPoint(Instant time, String name, Object value) {
            this(time, name, value, Collections.emptyMap());
        }

        public DataPoint(Instant time, String name, Object value, Map<String, String> tags) {
            this.name = Objects.requireNonNull(name, "name");
            this.time = Instant.from(Objects.requireNonNull(time, "time"));
            this.value = Objects.requireNonNull(value, "value");
            this.tags = ImmutableMap.copyOf(Objects.requireNonNull(tags, "tags"));
        }

        public String getName() {
            return this.name;
        }

        public Instant getTime() {
            return Instant.from(this.time);
        }

        public Object getValue() {
            return this.value;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="tags is ImmutableMap")
        public Map<String, String> getTags() {
            return this.tags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataPoint dataPoint = (DataPoint)o;
            return this.time == dataPoint.time && Objects.equals(this.value, dataPoint.value) && Objects.equals(this.name, dataPoint.name) && Objects.equals(this.tags, dataPoint.tags);
        }

        public String toString() {
            return "DataPoint{name='" + this.name + '\'' + ", time=" + this.time + ", value=" + this.value + ", tags=" + this.tags + '}';
        }

        public int hashCode() {
            return Objects.hash(this.name, this.time, this.value, this.tags);
        }
    }
}

