/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.internal.MetricsTagUtils;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThroughputMetricsReporter
implements MetricsReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThroughputMetricsReporter.class);
    private static final String THROUGHPUT_METRICS_GROUP = "ksql-query-throughput-metrics";
    private static final String RECORDS_CONSUMED = "records-consumed-total";
    private static final String BYTES_CONSUMED = "bytes-consumed-total";
    private static final String RECORDS_PRODUCED = "records-produced-total";
    private static final String BYTES_PRODUCED = "bytes-produced-total";
    private static final Set<String> THROUGHPUT_METRIC_NAMES = Utils.mkSet((Object[])new String[]{"records-consumed-total", "bytes-consumed-total", "records-produced-total", "bytes-produced-total"});
    private static final Map<String, Map<String, Map<MetricName, ThroughputTotalMetric>>> metrics = new HashMap<String, Map<String, Map<MetricName, ThroughputTotalMetric>>>();
    private static final Map<String, String> customTags = new HashMap<String, String>();
    private Metrics metricRegistry;

    public void init(List<KafkaMetric> initial) {
    }

    @VisibleForTesting
    static void reset() {
        metrics.clear();
    }

    public synchronized void configure(Map<String, ?> configMap) {
        this.metricRegistry = (Metrics)Objects.requireNonNull(configMap.get("ksql.internal.metrics"));
        customTags.putAll(KsqlConfig.getStringAsMap((String)"ksql.metrics.tags.custom", configMap));
    }

    public void metricChange(KafkaMetric metric) {
        if (!THROUGHPUT_METRIC_NAMES.contains(metric.metricName().name()) || !"stream-topic-metrics".equals(metric.metricName().group())) {
            return;
        }
        this.addMetric(metric, this.getQueryId(metric), this.getTopic(metric));
    }

    private synchronized void addMetric(KafkaMetric metric, String queryId, String topic) {
        ThroughputTotalMetric existingThroughputMetric;
        MetricName throughputTotalMetricName = this.getThroughputTotalMetricName(queryId, topic, metric.metricName());
        LOGGER.debug("Adding metric {}", (Object)throughputTotalMetricName);
        if (!metrics.containsKey(queryId)) {
            metrics.put(queryId, new HashMap());
        }
        if (!metrics.get(queryId).containsKey(topic)) {
            metrics.get(queryId).put(topic, new HashMap());
        }
        if ((existingThroughputMetric = metrics.get(queryId).get(topic).get(throughputTotalMetricName)) == null) {
            ThroughputTotalMetric newThroughputMetric = new ThroughputTotalMetric(metric);
            metrics.get(queryId).get(topic).put(throughputTotalMetricName, newThroughputMetric);
            this.metricRegistry.addMetric(throughputTotalMetricName, (Measurable)newThroughputMetric);
        } else {
            existingThroughputMetric.add(metric);
        }
    }

    public void metricRemoval(KafkaMetric metric) {
        if (!THROUGHPUT_METRIC_NAMES.contains(metric.metricName().name()) || !"stream-topic-metrics".equals(metric.metricName().group())) {
            return;
        }
        this.removeMetric(metric, this.getQueryId(metric), this.getTopic(metric));
    }

    private synchronized void removeMetric(KafkaMetric metric, String queryId, String topic) {
        MetricName throughputTotalMetricName = this.getThroughputTotalMetricName(queryId, topic, metric.metricName());
        LOGGER.debug("Removing metric {}", (Object)throughputTotalMetricName);
        if (metrics.containsKey(queryId) && metrics.get(queryId).containsKey(topic) && metrics.get(queryId).get(topic).containsKey(throughputTotalMetricName)) {
            ThroughputTotalMetric throughputTotalMetric = metrics.get(queryId).get(topic).get(throughputTotalMetricName);
            throughputTotalMetric.remove(metric.metricName());
            if (throughputTotalMetric.throughputTotalMetrics.isEmpty()) {
                metrics.get(queryId).get(topic).remove(throughputTotalMetricName);
                this.metricRegistry.removeMetric(throughputTotalMetricName);
                if (metrics.get(queryId).get(topic).isEmpty()) {
                    metrics.get(queryId).remove(topic);
                    if (metrics.get(queryId).isEmpty()) {
                        metrics.remove(queryId);
                    }
                }
            }
        }
    }

    public void close() {
    }

    public Set<String> reconfigurableConfigs() {
        return null;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    public void reconfigure(Map<String, ?> configs) {
    }

    public void contextChange(MetricsContext metricsContext) {
    }

    private MetricName getThroughputTotalMetricName(String queryId, String topic, MetricName metricName) {
        return new MetricName(metricName.name(), THROUGHPUT_METRICS_GROUP, metricName.description() + " by this query", this.getThroughputTotalMetricTags(queryId, topic, metricName.tags()));
    }

    private String getQueryId(KafkaMetric metric) {
        if (metric.metricName().tags().containsKey("query-id")) {
            return (String)metric.metricName().tags().get("query-id");
        }
        String taskName = metric.metricName().tags().getOrDefault("task-id", "");
        Matcher namedTopologyMatcher = MetricsTagUtils.SHARED_RUNTIME_THREAD_PATTERN.matcher(taskName);
        if (namedTopologyMatcher.find()) {
            return namedTopologyMatcher.group(1);
        }
        String queryIdTag = metric.metricName().tags().getOrDefault("thread-id", "");
        Matcher matcher = MetricsTagUtils.UNSHARED_RUNTIME_THREAD_PATTERN.matcher(queryIdTag);
        if (matcher.find()) {
            return matcher.group(1);
        }
        LOGGER.error("Can't parse query id from metric {}", (Object)metric.metricName());
        throw new KsqlException("Missing query ID when reporting total throughput metrics");
    }

    private String getTopic(KafkaMetric metric) {
        if (metric.metricName().tags().containsKey("topic")) {
            return (String)metric.metricName().tags().get("topic");
        }
        String topic = metric.metricName().tags().getOrDefault("topic", "");
        if (topic.equals("")) {
            LOGGER.error("Can't parse topic name from metric {}", (Object)metric);
            throw new KsqlException("Missing topic name when reporting total throughput metrics");
        }
        return topic;
    }

    private Map<String, String> getThroughputTotalMetricTags(String queryId, String topic, Map<String, String> originalStreamsMetricTags) {
        HashMap<String, String> queryMetricTags = new HashMap<String, String>(customTags);
        queryMetricTags.putAll(originalStreamsMetricTags);
        queryMetricTags.remove("task-id");
        queryMetricTags.remove("processor-node-id");
        String threadId = (String)queryMetricTags.remove("thread-id");
        queryMetricTags.put("member", threadId);
        queryMetricTags.put("query-id", queryId);
        return ImmutableMap.copyOf(queryMetricTags);
    }

    private static class ThroughputTotalMetric
    extends CumulativeSum {
        final Map<MetricName, KafkaMetric> throughputTotalMetrics = new HashMap<MetricName, KafkaMetric>();

        ThroughputTotalMetric(KafkaMetric metric) {
            this.add(metric);
        }

        private void add(KafkaMetric metric) {
            this.throughputTotalMetrics.put(metric.metricName(), metric);
        }

        private void remove(MetricName metric) {
            this.throughputTotalMetrics.remove(metric);
        }

        public double measure(MetricConfig metricConfig, long now) {
            return this.throughputTotalMetrics.values().stream().map(m -> (Double)m.metricValue()).reduce(Double::sum).orElse(0.0);
        }
    }
}

