/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.engine.QueryEventListener;
import io.confluent.ksql.engine.TransientQueryCleanupService;
import io.confluent.ksql.util.QueryMetadata;
import io.confluent.ksql.util.TransientQueryMetadata;
import org.apache.kafka.streams.KafkaStreams;

public class TransientQueryCleanupListener
implements QueryEventListener {
    private final TransientQueryCleanupService cleanupService;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public TransientQueryCleanupListener(TransientQueryCleanupService cleanupService) {
        this.cleanupService = cleanupService;
    }

    @Override
    public void onStateChange(QueryMetadata query, KafkaStreams.State before, KafkaStreams.State after) {
        if (query instanceof TransientQueryMetadata && before.isRunningOrRebalancing()) {
            String applicationId = query.getQueryApplicationId();
            this.cleanupService.registerRunningQuery(applicationId);
        }
    }
}

