/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logicalplanner.nodes;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.logicalplanner.nodes.Node;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.LogicalColumn;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.Objects;

public abstract class SourceNode<SourceT extends SourceNode<?>>
implements Node<SourceT> {
    final SourceName sourceName;
    final LogicalSchema simpleSchema;
    final ImmutableList<LogicalColumn> outputSchema;

    SourceNode(SourceName sourceName, LogicalSchema simpleSchema) {
        this.sourceName = Objects.requireNonNull(sourceName, "sourceName");
        this.simpleSchema = Objects.requireNonNull(simpleSchema, "simpleSchema");
        this.outputSchema = (ImmutableList)simpleSchema.columns().stream().map(column -> new LogicalColumn(column.name(), column.type())).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ImmutableList<LogicalColumn> getOutputSchema() {
        return this.outputSchema;
    }

    public SourceName getSourceName() {
        return this.sourceName;
    }

    public LogicalSchema getSimpleSchema() {
        return this.simpleSchema;
    }
}

