/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.physicalplanner;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.logicalplanner.nodes.NodeVisitor;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.physicalplanner.nodes.Node;
import io.confluent.ksql.physicalplanner.nodes.SelectNode;
import io.confluent.ksql.physicalplanner.nodes.StreamSourceNode;
import io.confluent.ksql.schema.ksql.LogicalColumn;
import java.util.Objects;

public class LogicalToPhysicalPlanTranslator
implements NodeVisitor<io.confluent.ksql.logicalplanner.nodes.Node<?>, Node<?>> {
    private final MetaStore metaStore;

    LogicalToPhysicalPlanTranslator(MetaStore metaStore) {
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
    }

    @Override
    public Node<?> process(io.confluent.ksql.logicalplanner.nodes.Node<?> node) {
        if (node instanceof io.confluent.ksql.logicalplanner.nodes.StreamSourceNode) {
            return this.processStreamSourceNode((io.confluent.ksql.logicalplanner.nodes.StreamSourceNode)node);
        }
        if (node instanceof io.confluent.ksql.logicalplanner.nodes.SelectNode) {
            io.confluent.ksql.logicalplanner.nodes.SelectNode selectNode = (io.confluent.ksql.logicalplanner.nodes.SelectNode)node;
            Object input = this.process((io.confluent.ksql.logicalplanner.nodes.Node)selectNode.getInputNode());
            return this.processSelectNode((Node<?>)input, selectNode);
        }
        throw new IllegalStateException("Unknown node type: " + node.getClass());
    }

    private StreamSourceNode processStreamSourceNode(io.confluent.ksql.logicalplanner.nodes.StreamSourceNode node) {
        SourceName sourceName = node.getSourceName();
        KsqlTopic topic = this.metaStore.getSource(sourceName).getKsqlTopic();
        return new StreamSourceNode(sourceName, node.getSimpleSchema(), topic.getKeyFormat(), topic.getValueFormat());
    }

    private Node<?> processSelectNode(Node<?> input, io.confluent.ksql.logicalplanner.nodes.SelectNode selectNode) {
        ImmutableList selectedColumns = (ImmutableList)selectNode.getOutputSchema().stream().map(LogicalColumn::name).collect(ImmutableList.toImmutableList());
        ImmutableList selectedKeys = (ImmutableList)input.keyColumnNames().stream().filter(arg_0 -> ((ImmutableList)selectedColumns).contains(arg_0)).collect(ImmutableList.toImmutableList());
        ImmutableList selectedValue = (ImmutableList)input.valueColumnNames().stream().filter(arg_0 -> ((ImmutableList)selectedColumns).contains(arg_0)).collect(ImmutableList.toImmutableList());
        return new SelectNode(input, (ImmutableList<ColumnName>)selectedKeys, (ImmutableList<ColumnName>)selectedValue);
    }
}

