/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.tree.AllColumns;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.StructAll;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Immutable
public final class Projection {
    private final boolean includesAll;
    private final ImmutableList<? extends SelectItem> selectItems;
    private final ImmutableSet<SourceName> includeAllSources;
    private final ImmutableSet<Expression> singles;
    private final ImmutableSet<Expression> structsAll;

    public static Projection of(Collection<? extends SelectItem> selectItems) {
        return new Projection(selectItems);
    }

    private Projection(Collection<? extends SelectItem> selects) {
        this.selectItems = ImmutableList.copyOf(selects);
        this.includesAll = selects.stream().filter(Projection::isAllColumn).map(AllColumns.class::cast).anyMatch(si -> !si.getSource().isPresent());
        this.includeAllSources = ImmutableSet.copyOf((Collection)selects.stream().filter(Projection::isAllColumn).map(AllColumns.class::cast).map(AllColumns::getSource).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet()));
        this.singles = ImmutableSet.copyOf((Collection)selects.stream().filter(Projection::isSingleColumn).map(SingleColumn.class::cast).map(SingleColumn::getExpression).collect(Collectors.toSet()));
        this.structsAll = ImmutableSet.copyOf((Collection)selects.stream().filter(Projection::isStructAll).map(StructAll.class::cast).map(StructAll::getBaseStruct).collect(Collectors.toSet()));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="selectItems is ImmutableList")
    public List<? extends SelectItem> selectItems() {
        return this.selectItems;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="singles is ImmutableSet")
    public Set<Expression> singleExpressions() {
        return this.singles;
    }

    public boolean containsExpression(Expression expression) {
        QualifiedColumnReferenceExp colRef;
        if (this.includesAll) {
            return true;
        }
        if (expression instanceof QualifiedColumnReferenceExp && this.includeAllSources.contains((Object)(colRef = (QualifiedColumnReferenceExp)expression).getQualifier())) {
            return true;
        }
        return this.singles.contains((Object)expression) || this.structsAll.contains((Object)expression);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Projection that = (Projection)o;
        return Objects.equals(this.selectItems, that.selectItems);
    }

    public int hashCode() {
        return Objects.hash(this.selectItems);
    }

    private static boolean isAllColumn(SelectItem si) {
        if (si instanceof SingleColumn) {
            return false;
        }
        if (si instanceof StructAll) {
            return false;
        }
        if (si instanceof AllColumns) {
            return true;
        }
        throw new UnsupportedOperationException("Unsupported column type: si.");
    }

    private static boolean isSingleColumn(SelectItem si) {
        return !Projection.isAllColumn(si) && !Projection.isStructAll(si);
    }

    private static boolean isStructAll(SelectItem si) {
        return si instanceof StructAll;
    }
}

