/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.engine.KsqlPlan;
import java.util.Objects;

public final class ConfiguredKsqlPlan {
    private final KsqlPlan plan;
    private final SessionConfig config;

    public static ConfiguredKsqlPlan of(KsqlPlan plan, SessionConfig config) {
        return new ConfiguredKsqlPlan(plan, config);
    }

    private ConfiguredKsqlPlan(KsqlPlan plan, SessionConfig config) {
        this.plan = Objects.requireNonNull(plan, "plan");
        this.config = Objects.requireNonNull(config, "config");
    }

    public KsqlPlan getPlan() {
        return this.plan;
    }

    public SessionConfig getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfiguredKsqlPlan that = (ConfiguredKsqlPlan)o;
        return Objects.equals(this.plan, that.plan) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.plan, this.config);
    }
}

