/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.udf.AsValue;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.planner.Projection;
import io.confluent.ksql.planner.RequiredColumns;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.ProjectNode;
import io.confluent.ksql.planner.plan.SelectionUtil;
import io.confluent.ksql.planner.plan.VerifiableNode;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.util.GrammaticalJoiner;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class FinalProjectNode
extends ProjectNode
implements VerifiableNode {
    private final Projection projection;
    private final Optional<Analysis.Into> into;
    private final LogicalSchema schema;
    private final ImmutableList<SelectExpression> selectExpressions;

    public FinalProjectNode(PlanNodeId id, PlanNode source, List<SelectItem> selectItems, Optional<Analysis.Into> into, MetaStore metaStore) {
        super(id, source);
        this.projection = Projection.of(selectItems);
        this.into = into;
        Pair<LogicalSchema, List<SelectExpression>> result = this.build(metaStore);
        this.schema = (LogicalSchema)result.left;
        this.selectExpressions = ImmutableList.copyOf((Collection)((Collection)result.right));
        this.throwOnEmptyValueOrUnknownColumns();
    }

    @Override
    public LogicalSchema getSchema() {
        return this.schema;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="selectExpressions is ImmutableList")
    public List<SelectExpression> getSelectExpressions() {
        return this.selectExpressions;
    }

    @Override
    public void validateKeyPresent(SourceName sinkName) {
        this.getSource().validateKeyPresent(sinkName, this.projection);
    }

    private Optional<LogicalSchema> getTargetSchema(MetaStore metaStore) {
        return this.into.filter(i -> !i.isCreate()).map(i -> metaStore.getSource(i.getName())).map(DataSource::getSchema);
    }

    private Pair<LogicalSchema, List<SelectExpression>> build(MetaStore metaStore) {
        LogicalSchema nodeSchema;
        LogicalSchema parentSchema = this.getSource().getSchema();
        Optional<LogicalSchema> targetSchema = this.getTargetSchema(metaStore);
        List<SelectExpression> selectExpressions = SelectionUtil.buildSelectExpressions(this.getSource(), this.projection.selectItems(), targetSchema);
        LogicalSchema schema = SelectionUtil.buildProjectionSchema(parentSchema, selectExpressions, (FunctionRegistry)metaStore);
        if (this.into.isPresent()) {
            HashMap seenKeyColumns = new HashMap();
            selectExpressions.removeIf(se -> {
                if (se.getExpression() instanceof UnqualifiedColumnReferenceExp) {
                    ColumnName columnName = ((UnqualifiedColumnReferenceExp)se.getExpression()).getColumnName();
                    if (SystemColumns.isWindowBound((ColumnName)columnName) && se.getAlias().equals((Object)columnName)) {
                        return true;
                    }
                    if (parentSchema.isKeyColumn(columnName)) {
                        seenKeyColumns.computeIfAbsent(columnName, k -> new HashSet()).add(se.getAlias());
                        return true;
                    }
                }
                return false;
            });
            for (Map.Entry seenKey : seenKeyColumns.entrySet()) {
                if (((Set)seenKey.getValue()).size() <= 1) continue;
                String keys = GrammaticalJoiner.and().join(((Set)seenKey.getValue()).stream().map(Name::text).sorted());
                throw new KsqlException("The projection contains a key column (" + seenKey.getKey() + ") more than once, aliased as: " + keys + "." + System.lineSeparator() + "Each key column must only be in the projection once. If you intended to copy the key into the value, then consider using the " + AsValue.NAME + " function to indicate which key reference should be copied.");
            }
        }
        if (this.into.isPresent()) {
            nodeSchema = schema.withoutPseudoAndKeyColsInValue();
        } else {
            LogicalSchema.Builder builder = LogicalSchema.builder();
            builder.keyColumns((Iterable)parentSchema.key());
            schema.columns().forEach(arg_0 -> ((LogicalSchema.Builder)builder).valueColumn(arg_0));
            nodeSchema = builder.build();
        }
        return Pair.of((Object)nodeSchema, selectExpressions);
    }

    private void throwOnEmptyValueOrUnknownColumns() {
        LogicalSchema schema = this.getSchema();
        if (schema.value().isEmpty()) {
            throw new KsqlException("The projection contains no value columns.");
        }
        this.validateProjection();
    }

    private void validateProjection() {
        RequiredColumns requiredColumns = RequiredColumns.builder().addAll(this.projection.singleExpressions()).build();
        Set<ColumnReferenceExp> unknown = this.getSource().validateColumns(requiredColumns);
        if (!unknown.isEmpty()) {
            String errors = unknown.stream().map(columnRef -> NodeLocation.asPrefix((Optional)columnRef.getLocation()) + "Column '" + columnRef + "' cannot be resolved.").collect(Collectors.joining(System.lineSeparator()));
            throw new KsqlException(errors);
        }
    }
}

