/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import io.confluent.ksql.engine.rewrite.ExpressionTreeRewriter;
import io.confluent.ksql.execution.expression.tree.BooleanLiteral;
import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.LogicalBinaryExpression;
import io.confluent.ksql.execution.expression.tree.NotExpression;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.VisitParentExpressionVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class LogicRewriter {
    private LogicRewriter() {
    }

    public static Expression rewriteNegations(Expression expression) {
        return new ExpressionTreeRewriter<NotPropagatorContext>((arg_0, arg_1) -> ((NotPropagator)new NotPropagator()).process(arg_0, arg_1)).rewrite(expression, new NotPropagatorContext());
    }

    public static Expression rewriteCNF(Expression expression) {
        Expression notPropagated = new ExpressionTreeRewriter<NotPropagatorContext>((arg_0, arg_1) -> ((NotPropagator)new NotPropagator()).process(arg_0, arg_1)).rewrite(expression, new NotPropagatorContext());
        return new ExpressionTreeRewriter<Object>((arg_0, arg_1) -> ((DistributiveLawApplierDisjunctionOverConjunction)new DistributiveLawApplierDisjunctionOverConjunction()).process(arg_0, arg_1)).rewrite(notPropagated, null);
    }

    public static Expression rewriteDNF(Expression expression) {
        Expression notPropagated = new ExpressionTreeRewriter<NotPropagatorContext>((arg_0, arg_1) -> ((NotPropagator)new NotPropagator()).process(arg_0, arg_1)).rewrite(expression, new NotPropagatorContext());
        return new ExpressionTreeRewriter<Object>((arg_0, arg_1) -> ((DistributiveLawApplierConjunctionOverDisjunction)new DistributiveLawApplierConjunctionOverDisjunction()).process(arg_0, arg_1)).rewrite(notPropagated, null);
    }

    public static List<Expression> extractDisjuncts(Expression expression) {
        Expression dnf = LogicRewriter.rewriteDNF(expression);
        DisjunctExtractor disjunctExtractor = new DisjunctExtractor();
        disjunctExtractor.process(dnf, null);
        return disjunctExtractor.getDisjuncts();
    }

    private static final class DisjunctExtractor
    extends VisitParentExpressionVisitor<Void, Void> {
        private List<Expression> disjuncts = new ArrayList<Expression>();

        private DisjunctExtractor() {
        }

        public Void visitExpression(Expression node, Void context) {
            this.disjuncts.add(node);
            return null;
        }

        public Void visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            if (node.getType() == LogicalBinaryExpression.Type.AND) {
                this.disjuncts.add((Expression)node);
            } else {
                this.process(node.getLeft(), context);
                this.process(node.getRight(), context);
            }
            return null;
        }

        public List<Expression> getDisjuncts() {
            return this.disjuncts;
        }
    }

    private static final class DistributiveLawApplierConjunctionOverDisjunction
    extends VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>> {
        private DistributiveLawApplierConjunctionOverDisjunction() {
        }

        public Optional<Expression> visitExpression(Expression node, ExpressionTreeRewriter.Context<Void> context) {
            return Optional.empty();
        }

        public Optional<Expression> visitLogicalBinaryExpression(LogicalBinaryExpression node, ExpressionTreeRewriter.Context<Void> context) {
            boolean isLeftLogicalExp = node.getLeft() instanceof LogicalBinaryExpression;
            boolean isRightLogicalExp = node.getRight() instanceof LogicalBinaryExpression;
            if (!isLeftLogicalExp && !isRightLogicalExp) {
                return Optional.empty();
            }
            Expression left = ((Optional)this.process(node.getLeft(), context)).orElse(node.getLeft());
            Expression right = ((Optional)this.process(node.getRight(), context)).orElse(node.getRight());
            if (node.getType() == LogicalBinaryExpression.Type.AND) {
                LogicalBinaryExpression rightLogical;
                LogicalBinaryExpression leftLogical;
                if (left instanceof LogicalBinaryExpression && (leftLogical = (LogicalBinaryExpression)left).getType() == LogicalBinaryExpression.Type.OR) {
                    LogicalBinaryExpression leftOr = new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.AND, leftLogical.getLeft(), right);
                    leftOr = (Expression)((Optional)this.process((Expression)leftOr, context)).orElse(leftOr);
                    LogicalBinaryExpression rightOr = new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.AND, leftLogical.getRight(), right);
                    rightOr = (Expression)((Optional)this.process((Expression)rightOr, context)).orElse(rightOr);
                    return Optional.of(new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.OR, (Expression)leftOr, (Expression)rightOr));
                }
                if (right instanceof LogicalBinaryExpression && (rightLogical = (LogicalBinaryExpression)right).getType() == LogicalBinaryExpression.Type.OR) {
                    LogicalBinaryExpression leftOr = new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.AND, left, rightLogical.getLeft());
                    leftOr = (Expression)((Optional)this.process((Expression)leftOr, context)).orElse(leftOr);
                    LogicalBinaryExpression rightOr = new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.AND, left, rightLogical.getRight());
                    rightOr = (Expression)((Optional)this.process((Expression)rightOr, context)).orElse(rightOr);
                    return Optional.of(new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.OR, (Expression)leftOr, (Expression)rightOr));
                }
            }
            return Optional.of(new LogicalBinaryExpression(node.getLocation(), node.getType(), left, right));
        }
    }

    private static final class DistributiveLawApplierDisjunctionOverConjunction
    extends VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>> {
        private DistributiveLawApplierDisjunctionOverConjunction() {
        }

        public Optional<Expression> visitExpression(Expression node, ExpressionTreeRewriter.Context<Void> context) {
            return Optional.empty();
        }

        public Optional<Expression> visitLogicalBinaryExpression(LogicalBinaryExpression node, ExpressionTreeRewriter.Context<Void> context) {
            boolean isLeftLogicalExp = node.getLeft() instanceof LogicalBinaryExpression;
            boolean isRightLogicalExp = node.getRight() instanceof LogicalBinaryExpression;
            if (!isLeftLogicalExp && !isRightLogicalExp) {
                return Optional.empty();
            }
            Expression left = ((Optional)this.process(node.getLeft(), context)).orElse(node.getLeft());
            Expression right = ((Optional)this.process(node.getRight(), context)).orElse(node.getRight());
            if (node.getType() == LogicalBinaryExpression.Type.OR) {
                LogicalBinaryExpression rightLogical;
                LogicalBinaryExpression leftLogical;
                if (left instanceof LogicalBinaryExpression && (leftLogical = (LogicalBinaryExpression)left).getType() == LogicalBinaryExpression.Type.AND) {
                    LogicalBinaryExpression leftOr = new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.OR, leftLogical.getLeft(), right);
                    leftOr = (Expression)((Optional)this.process((Expression)leftOr, context)).orElse(leftOr);
                    LogicalBinaryExpression rightOr = new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.OR, leftLogical.getRight(), right);
                    rightOr = (Expression)((Optional)this.process((Expression)rightOr, context)).orElse(rightOr);
                    return Optional.of(new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.AND, (Expression)leftOr, (Expression)rightOr));
                }
                if (right instanceof LogicalBinaryExpression && (rightLogical = (LogicalBinaryExpression)right).getType() == LogicalBinaryExpression.Type.AND) {
                    LogicalBinaryExpression leftOr = new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.OR, left, rightLogical.getLeft());
                    leftOr = (Expression)((Optional)this.process((Expression)leftOr, context)).orElse(leftOr);
                    LogicalBinaryExpression rightOr = new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.OR, left, rightLogical.getRight());
                    rightOr = (Expression)((Optional)this.process((Expression)rightOr, context)).orElse(rightOr);
                    return Optional.of(new LogicalBinaryExpression(node.getLocation(), LogicalBinaryExpression.Type.AND, (Expression)leftOr, (Expression)rightOr));
                }
            }
            return Optional.of(new LogicalBinaryExpression(node.getLocation(), node.getType(), left, right));
        }
    }

    public static final class NotPropagatorContext {
        boolean isNegated = false;

        public void negate() {
            this.isNegated = !this.isNegated;
        }

        public boolean isNegated() {
            return this.isNegated;
        }

        public void restore(boolean isNegated) {
            this.isNegated = isNegated;
        }
    }

    private static final class NotPropagator
    extends VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<NotPropagatorContext>> {
        private NotPropagator() {
        }

        public Optional<Expression> visitExpression(Expression node, ExpressionTreeRewriter.Context<NotPropagatorContext> context) {
            return Optional.empty();
        }

        public Optional<Expression> visitUnqualifiedColumnReference(UnqualifiedColumnReferenceExp node, ExpressionTreeRewriter.Context<NotPropagatorContext> context) {
            return this.handlePrimitiveTerm((Expression)node, context);
        }

        public Optional<Expression> visitQualifiedColumnReference(QualifiedColumnReferenceExp node, ExpressionTreeRewriter.Context<NotPropagatorContext> context) {
            return this.handlePrimitiveTerm((Expression)node, context);
        }

        public Optional<Expression> visitBooleanLiteral(BooleanLiteral node, ExpressionTreeRewriter.Context<NotPropagatorContext> context) {
            return this.handlePrimitiveTerm((Expression)node, context);
        }

        private Optional<Expression> handlePrimitiveTerm(Expression node, ExpressionTreeRewriter.Context<NotPropagatorContext> context) {
            if (!context.getContext().isNegated()) {
                return Optional.empty();
            }
            return Optional.of(new NotExpression(node.getLocation(), node));
        }

        public Optional<Expression> visitLogicalBinaryExpression(LogicalBinaryExpression node, ExpressionTreeRewriter.Context<NotPropagatorContext> context) {
            boolean isNegated = context.getContext().isNegated();
            Expression left = ((Optional)this.process(node.getLeft(), context)).orElse(node.getLeft());
            context.getContext().restore(isNegated);
            Expression right = ((Optional)this.process(node.getRight(), context)).orElse(node.getRight());
            context.getContext().restore(isNegated);
            LogicalBinaryExpression.Type type = node.getType();
            if (isNegated) {
                type = node.getType() == LogicalBinaryExpression.Type.AND ? LogicalBinaryExpression.Type.OR : LogicalBinaryExpression.Type.AND;
            }
            return Optional.of(new LogicalBinaryExpression(node.getLocation(), type, left, right));
        }

        public Optional<Expression> visitComparisonExpression(ComparisonExpression node, ExpressionTreeRewriter.Context<NotPropagatorContext> context) {
            return this.handlePrimitiveTerm((Expression)node, context);
        }

        public Optional<Expression> visitNotExpression(NotExpression node, ExpressionTreeRewriter.Context<NotPropagatorContext> context) {
            context.getContext().negate();
            Expression value = ((Optional)this.process(node.getValue(), context)).orElse(node.getValue());
            return Optional.of(value);
        }
    }
}

