/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.SingleSourcePlanNode;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public abstract class OutputNode
extends SingleSourcePlanNode {
    private final OptionalInt limit;
    private final Optional<TimestampColumn> timestampColumn;
    private final LogicalSchema schema;

    protected OutputNode(PlanNodeId id, PlanNode source, LogicalSchema schema, OptionalInt limit, Optional<TimestampColumn> timestampColumn) {
        super(id, source.getNodeOutputType(), source.getSourceName(), source);
        this.schema = Objects.requireNonNull(schema, "schema");
        this.limit = Objects.requireNonNull(limit, "limit");
        this.timestampColumn = Objects.requireNonNull(timestampColumn, "timestampColumn");
    }

    @Override
    public LogicalSchema getSchema() {
        return this.schema;
    }

    public OptionalInt getLimit() {
        return this.limit;
    }

    public Optional<TimestampColumn> getTimestampColumn() {
        return this.timestampColumn;
    }

    public abstract Optional<SourceName> getSinkName();
}

