/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.planner.RequiredColumns;
import io.confluent.ksql.planner.plan.DataSourceNode;
import io.confluent.ksql.planner.plan.JoiningNode;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.ProjectNode;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.ColumnNames;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.KeyFormat;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PreJoinProjectNode
extends ProjectNode
implements JoiningNode {
    private final ImmutableList<SelectExpression> selectExpressions;
    private final ImmutableBiMap<ColumnName, ColumnName> aliases;
    private final LogicalSchema schema;
    private final Optional<JoiningNode> joiningSource;

    public PreJoinProjectNode(PlanNodeId id, PlanNode source, SourceName alias) {
        super(id, source);
        this.selectExpressions = ImmutableList.copyOf(PreJoinProjectNode.buildSelectExpressions(alias, source.getSchema()));
        this.aliases = PreJoinProjectNode.buildAliasMapping(this.selectExpressions);
        this.schema = PreJoinProjectNode.buildSchema(alias, source.getSchema());
        if (source instanceof JoiningNode) {
            this.joiningSource = Optional.of((JoiningNode)((Object)source));
        } else {
            if (!(source instanceof DataSourceNode)) {
                throw new IllegalStateException("PreJoinProjectNode preceded by non-DataSourceNode non-JoiningNode: " + source.getClass());
            }
            this.joiningSource = Optional.empty();
        }
    }

    @Override
    public LogicalSchema getSchema() {
        return this.schema;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="selectExpressions is ImmutableList")
    public List<SelectExpression> getSelectExpressions() {
        return this.selectExpressions;
    }

    @Override
    public Optional<KeyFormat> getPreferredKeyFormat() {
        if (this.joiningSource.isPresent()) {
            return this.joiningSource.get().getPreferredKeyFormat();
        }
        KeyFormat sourceKeyFormat = ((DataSourceNode)Iterators.getOnlyElement(this.getSourceNodes().iterator())).getDataSource().getKsqlTopic().getKeyFormat();
        return Optional.of(sourceKeyFormat);
    }

    @Override
    public void setKeyFormat(KeyFormat format) {
        this.joiningSource.ifPresent(source -> source.setKeyFormat(format));
    }

    @Override
    public Stream<ColumnName> resolveSelectStar(Optional<SourceName> sourceName) {
        return this.getSource().resolveSelectStar(sourceName).map(name -> (ColumnName)this.aliases.getOrDefault(name, name));
    }

    @Override
    protected Set<ColumnReferenceExp> validateColumns(RequiredColumns requiredColumns) {
        List<ColumnReferenceExp> aliased = requiredColumns.get().stream().filter(columnRef -> columnRef instanceof UnqualifiedColumnReferenceExp).filter(columnRef -> this.aliases.inverse().containsKey((Object)columnRef.getColumnName())).collect(Collectors.toList());
        RequiredColumns.Builder builder = requiredColumns.asBuilder();
        aliased.forEach(columnRef -> {
            builder.remove((ColumnReferenceExp)columnRef);
            builder.add((Expression)new UnqualifiedColumnReferenceExp(columnRef.getLocation(), (ColumnName)this.aliases.inverse().get((Object)columnRef.getColumnName())));
        });
        return super.validateColumns(builder.build());
    }

    private static ImmutableBiMap<ColumnName, ColumnName> buildAliasMapping(List<SelectExpression> projectExpressions) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        projectExpressions.stream().filter(se -> se.getExpression() instanceof ColumnReferenceExp).forEach(se -> builder.put((Object)((ColumnReferenceExp)se.getExpression()).getColumnName(), (Object)se.getAlias()));
        return builder.build();
    }

    private static LogicalSchema buildSchema(SourceName alias, LogicalSchema parentSchema) {
        LogicalSchema.Builder builder = LogicalSchema.builder();
        parentSchema.columns().forEach(c -> {
            ColumnName aliasedName = ColumnNames.generatedJoinColumnAlias((SourceName)alias, (ColumnName)c.name());
            if (c.namespace() == Column.Namespace.KEY) {
                builder.keyColumn(aliasedName, c.type());
            } else {
                builder.valueColumn(aliasedName, c.type());
            }
        });
        return builder.build();
    }

    private static List<SelectExpression> buildSelectExpressions(SourceName alias, LogicalSchema schema) {
        return schema.value().stream().map(c -> SelectExpression.of((ColumnName)ColumnNames.generatedJoinColumnAlias((SourceName)alias, (ColumnName)c.name()), (Expression)new UnqualifiedColumnReferenceExp(c.name()))).collect(Collectors.toList());
    }
}

