/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.SingleSourcePlanNode;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.structured.SchemaKStream;
import java.util.List;
import java.util.stream.Collectors;

public abstract class ProjectNode
extends SingleSourcePlanNode {
    public ProjectNode(PlanNodeId id, PlanNode source) {
        super(id, source.getNodeOutputType(), source.getSourceName(), source);
    }

    public abstract List<SelectExpression> getSelectExpressions();

    @Override
    public SchemaKStream<?> buildStream(PlanBuildContext buildContext) {
        SchemaKStream<?> stream = this.getSource().buildStream(buildContext);
        List<ColumnName> keyColumnNames = this.getSchema().key().stream().map(Column::name).collect(Collectors.toList());
        return stream.select(keyColumnNames, this.getSelectExpressions(), buildContext.buildNodeContext(this.getId().toString()), buildContext, this.getFormatInfo());
    }

    public FormatInfo getFormatInfo() {
        return this.getLeftmostSourceNode().getDataSource().getKsqlTopic().getValueFormat().getFormatInfo();
    }
}

