/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryErrorClassifier;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegexClassifier
implements QueryErrorClassifier {
    private static final Logger LOG = LoggerFactory.getLogger(RegexClassifier.class);
    private final Pattern pattern;
    private final QueryError.Type type;
    private final String queryId;

    public static QueryErrorClassifier fromConfig(String config, String queryId) {
        String[] split = config.split("\\s", 2);
        if (split.length < 2) {
            LOG.warn("Ignoring invalid configuration for RegexClassifier: " + config);
            return err -> QueryError.Type.UNKNOWN;
        }
        return new RegexClassifier(QueryError.Type.valueOf((String)split[0].toUpperCase()), Pattern.compile(split[1], 32), queryId);
    }

    private RegexClassifier(QueryError.Type type, Pattern pattern, String queryId) {
        this.type = Objects.requireNonNull(type, "type");
        this.pattern = Objects.requireNonNull(pattern, "pattern");
        this.queryId = Objects.requireNonNull(queryId, "queryId");
    }

    public QueryError.Type classify(Throwable e) {
        LOG.info("Attempting to classify for {} under regex pattern {}.", (Object)this.queryId, (Object)this.pattern);
        Throwable error = e;
        do {
            if (!this.matches(error)) continue;
            LOG.warn("Classified error for queryId {} under regex pattern {} as type {}.", new Object[]{this.queryId, this.pattern, this.type});
            return this.type;
        } while ((error = error.getCause()) != null);
        return QueryError.Type.UNKNOWN;
    }

    private boolean matches(Throwable e) {
        boolean clsMatches = this.pattern.matcher(e.getClass().getName()).matches();
        boolean msgMatches = e.getMessage() != null && this.pattern.matcher(e.getMessage()).matches();
        return clsMatches || msgMatches;
    }
}

