/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.inference;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.execution.ddl.commands.CreateSourceCommand;
import io.confluent.ksql.execution.expression.tree.Type;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.SqlFormatter;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import io.confluent.ksql.parser.properties.with.CreateSourceProperties;
import io.confluent.ksql.parser.properties.with.SourcePropertiesUtil;
import io.confluent.ksql.parser.tree.ColumnConstraints;
import io.confluent.ksql.parser.tree.CreateAsSelect;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.TableElement;
import io.confluent.ksql.parser.tree.TableElements;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.inference.TopicSchemaSupplier;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.SerdeFeaturesFactory;
import io.confluent.ksql.services.SandboxedServiceContext;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.util.ErrorMessageUtil;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlStatementException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DefaultSchemaInjector
implements Injector {
    private static final ColumnConstraints KEY_CONSTRAINT = new ColumnConstraints.Builder().key().build();
    private static final ColumnConstraints PRIMARY_KEY_CONSTRAINT = new ColumnConstraints.Builder().primaryKey().build();
    private final TopicSchemaSupplier schemaSupplier;
    private final KsqlExecutionContext executionContext;
    private final ServiceContext serviceContext;

    public DefaultSchemaInjector(TopicSchemaSupplier schemaSupplier, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        this.schemaSupplier = Objects.requireNonNull(schemaSupplier, "schemaSupplier");
        this.executionContext = Objects.requireNonNull(executionContext, "executionContext");
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
    }

    @Override
    public <T extends Statement> ConfiguredStatement<T> inject(ConfiguredStatement<T> statement) {
        if (!(statement.getStatement() instanceof CreateSource) && !(statement.getStatement() instanceof CreateAsSelect)) {
            return statement;
        }
        try {
            if (statement.getStatement() instanceof CreateSource) {
                ConfiguredStatement<CreateSource> createStatement = statement;
                return this.forCreateStatement(createStatement).orElse(createStatement);
            }
            ConfiguredStatement<CreateSource> createStatement = statement;
            return this.forCreateAsStatement(createStatement).orElse(createStatement);
        }
        catch (KsqlStatementException e) {
            throw e;
        }
        catch (KsqlException e) {
            throw new KsqlStatementException(ErrorMessageUtil.buildErrorMessage((Throwable)e), statement.getMaskedStatementText(), e.getCause());
        }
    }

    private Optional<ConfiguredStatement<CreateAsSelect>> forCreateAsStatement(ConfiguredStatement<CreateAsSelect> statement) {
        CreateSourceCommand createSourceCommand;
        CreateAsSelect csStmt = statement.getStatement();
        CreateSourceAsProperties properties = csStmt.getProperties();
        if (!properties.getKeySchemaId().isPresent() && !properties.getValueSchemaId().isPresent()) {
            return Optional.empty();
        }
        try {
            SandboxedServiceContext sandboxServiceContext = SandboxedServiceContext.create(this.serviceContext);
            createSourceCommand = (CreateSourceCommand)this.executionContext.createSandbox(sandboxServiceContext).plan(sandboxServiceContext, statement).getDdlCommand().get();
        }
        catch (Exception e) {
            throw new KsqlStatementException("Could not determine output schema for query due to error: " + e.getMessage(), statement.getMaskedStatementText(), (Throwable)e);
        }
        Optional<TopicSchemaSupplier.SchemaAndId> keySchema = this.getCreateAsKeySchema(statement, createSourceCommand);
        Optional<TopicSchemaSupplier.SchemaAndId> valueSchema = this.getCreateAsValueSchema(statement, createSourceCommand);
        CreateAsSelect withSchema = DefaultSchemaInjector.addSchemaFieldsCas(statement, keySchema, valueSchema);
        KsqlParser.PreparedStatement<CreateAsSelect> prepared = DefaultSchemaInjector.buildPreparedStatement(withSchema);
        ImmutableMap.Builder overrideBuilder = ImmutableMap.builder();
        if (properties.getKeySchemaId().isPresent()) {
            keySchema.map(schemaAndId -> overrideBuilder.put((Object)"KEY_SCHEMA_ID", schemaAndId));
        }
        if (properties.getValueSchemaId().isPresent()) {
            valueSchema.map(schemaAndId -> overrideBuilder.put((Object)"VALUE_SCHEMA_ID", schemaAndId));
        }
        ConfiguredStatement<CreateAsSelect> configured = ConfiguredStatement.of(prepared, statement.getSessionConfig().copyWith((Map)overrideBuilder.build()));
        return Optional.of(configured);
    }

    private Optional<TopicSchemaSupplier.SchemaAndId> getCreateAsKeySchema(ConfiguredStatement<CreateAsSelect> statement, CreateSourceCommand createSourceCommand) {
        CreateAsSelect csStmt = statement.getStatement();
        CreateSourceAsProperties props = csStmt.getProperties();
        FormatInfo keyFormat = createSourceCommand.getFormats().getKeyFormat();
        if (!DefaultSchemaInjector.shouldInferSchema(props.getKeySchemaId(), statement, keyFormat, true)) {
            return Optional.empty();
        }
        SerdeFeatures serdeFeatures = SerdeFeaturesFactory.buildKeyFeatures(FormatFactory.of((FormatInfo)keyFormat), true);
        if (!DefaultSchemaInjector.shouldInferSchema(props.getKeySchemaId(), statement, keyFormat, true)) {
            return Optional.empty();
        }
        TopicSchemaSupplier.SchemaAndId schemaAndId = this.getSchema(props.getKafkaTopic(), props.getKeySchemaId(), keyFormat, serdeFeatures, statement.getMaskedStatementText(), true);
        List tableColumns = createSourceCommand.getSchema().key();
        DefaultSchemaInjector.checkColumnsCompatibility(props.getKeySchemaId(), tableColumns, schemaAndId.columns, true);
        return Optional.of(schemaAndId);
    }

    private Optional<TopicSchemaSupplier.SchemaAndId> getCreateAsValueSchema(ConfiguredStatement<CreateAsSelect> statement, CreateSourceCommand createSourceCommand) {
        CreateAsSelect csStmt = statement.getStatement();
        CreateSourceAsProperties props = csStmt.getProperties();
        FormatInfo valueFormat = createSourceCommand.getFormats().getValueFormat();
        if (!DefaultSchemaInjector.shouldInferSchema(props.getValueSchemaId(), statement, valueFormat, false)) {
            return Optional.empty();
        }
        TopicSchemaSupplier.SchemaAndId schemaAndId = this.getSchema(props.getKafkaTopic(), props.getValueSchemaId(), valueFormat, createSourceCommand.getFormats().getValueFeatures(), statement.getMaskedStatementText(), false);
        List tableColumns = createSourceCommand.getSchema().value();
        DefaultSchemaInjector.checkColumnsCompatibility(props.getValueSchemaId(), tableColumns, schemaAndId.columns, false);
        return Optional.of(schemaAndId);
    }

    private Optional<ConfiguredStatement<CreateSource>> forCreateStatement(ConfiguredStatement<CreateSource> statement) {
        Optional<TopicSchemaSupplier.SchemaAndId> keySchema = this.getKeySchema(statement);
        Optional<TopicSchemaSupplier.SchemaAndId> valueSchema = this.getValueSchema(statement);
        if (!keySchema.isPresent() && !valueSchema.isPresent()) {
            return Optional.empty();
        }
        CreateSource withSchema = DefaultSchemaInjector.addSchemaFields(statement, keySchema, valueSchema);
        KsqlParser.PreparedStatement<CreateSource> prepared = DefaultSchemaInjector.buildPreparedStatement(withSchema);
        ImmutableMap.Builder overrideBuilder = ImmutableMap.builder();
        if (withSchema.getProperties().getKeySchemaId().isPresent()) {
            keySchema.map(schemaAndId -> overrideBuilder.put((Object)"KEY_SCHEMA_ID", schemaAndId));
        }
        if (withSchema.getProperties().getValueSchemaId().isPresent()) {
            valueSchema.map(schemaAndId -> overrideBuilder.put((Object)"VALUE_SCHEMA_ID", schemaAndId));
        }
        ConfiguredStatement<CreateSource> configured = ConfiguredStatement.of(prepared, statement.getSessionConfig().copyWith((Map)overrideBuilder.build()));
        return Optional.of(configured);
    }

    private Optional<TopicSchemaSupplier.SchemaAndId> getKeySchema(ConfiguredStatement<CreateSource> statement) {
        CreateSource csStmt = statement.getStatement();
        CreateSourceProperties props = csStmt.getProperties();
        FormatInfo keyFormat = SourcePropertiesUtil.getKeyFormat((CreateSourceProperties)props, (SourceName)csStmt.getName());
        if (!DefaultSchemaInjector.shouldInferSchema(props.getKeySchemaId(), statement, keyFormat, true)) {
            return Optional.empty();
        }
        return Optional.of(this.getSchema(Optional.of(props.getKafkaTopic()), props.getKeySchemaId(), keyFormat, SerdeFeaturesFactory.buildKeyFeatures(FormatFactory.of((FormatInfo)keyFormat), true), statement.getMaskedStatementText(), true));
    }

    private Optional<TopicSchemaSupplier.SchemaAndId> getValueSchema(ConfiguredStatement<CreateSource> statement) {
        CreateSourceProperties props = statement.getStatement().getProperties();
        FormatInfo valueFormat = SourcePropertiesUtil.getValueFormat((CreateSourceProperties)props);
        if (!DefaultSchemaInjector.shouldInferSchema(props.getValueSchemaId(), statement, valueFormat, false)) {
            return Optional.empty();
        }
        return Optional.of(this.getSchema(Optional.of(props.getKafkaTopic()), props.getValueSchemaId(), valueFormat, props.getValueSerdeFeatures(), statement.getMaskedStatementText(), false));
    }

    private TopicSchemaSupplier.SchemaAndId getSchema(Optional<String> topicName, Optional<Integer> schemaId, FormatInfo expectedFormat, SerdeFeatures serdeFeatures, String statementText, boolean isKey) {
        TopicSchemaSupplier.SchemaResult result;
        TopicSchemaSupplier.SchemaResult schemaResult = result = isKey ? this.schemaSupplier.getKeySchema(topicName, schemaId, expectedFormat, serdeFeatures) : this.schemaSupplier.getValueSchema(topicName, schemaId, expectedFormat, serdeFeatures);
        if (result.failureReason.isPresent()) {
            Exception cause = result.failureReason.get();
            throw new KsqlStatementException(cause.getMessage(), statementText, (Throwable)cause);
        }
        return result.schemaAndId.get();
    }

    private static boolean shouldInferSchema(Optional<Integer> schemaId, ConfiguredStatement<? extends Statement> statement, FormatInfo formatInfo, boolean isKey) {
        boolean hasTableElements;
        Format format;
        String formatProp = isKey ? "KEY_FORMAT" : "VALUE_FORMAT";
        String schemaIdName = isKey ? "KEY_SCHEMA_ID" : "VALUE_SCHEMA_ID";
        String formatPropMsg = String.format("%s should support schema inference when %s is provided. Current format is %s.", formatProp, schemaIdName, formatInfo.getFormat());
        try {
            format = FormatFactory.of((FormatInfo)formatInfo);
        }
        catch (KsqlException e) {
            if (e.getMessage().contains("does not support the following configs: [schemaId]")) {
                throw new KsqlException(formatPropMsg);
            }
            throw e;
        }
        boolean cas = statement.getStatement() instanceof CreateAsSelect;
        if (cas) {
            hasTableElements = false;
        } else {
            boolean bl = hasTableElements = isKey ? DefaultSchemaInjector.hasKeyElements(statement) : DefaultSchemaInjector.hasValueElements(statement);
        }
        if (schemaId.isPresent()) {
            if (!DefaultSchemaInjector.formatSupportsSchemaInference(format)) {
                throw new KsqlException(formatPropMsg);
            }
            if (hasTableElements) {
                String msg = "Table elements and " + schemaIdName + " cannot both exist for create statement.";
                throw new KsqlException(msg);
            }
            return true;
        }
        return !cas && !hasTableElements && DefaultSchemaInjector.formatSupportsSchemaInference(format);
    }

    private static void checkColumnsCompatibility(Optional<Integer> schemaId, List<Column> tableColumns, List<? extends SimpleColumn> connectColumns, boolean isKey) {
        ImmutableSet colB;
        if (!schemaId.isPresent()) {
            return;
        }
        if (tableColumns.isEmpty()) {
            return;
        }
        Column.Namespace namespace = isKey ? Column.Namespace.KEY : Column.Namespace.VALUE;
        List inferredColumns = IntStream.range(0, connectColumns.size()).mapToObj(i -> Column.of((ColumnName)((SimpleColumn)connectColumns.get(i)).name(), (SqlType)((SimpleColumn)connectColumns.get(i)).type(), (Column.Namespace)namespace, (int)i)).collect(Collectors.toList());
        ImmutableSet colA = ImmutableSet.copyOf(tableColumns);
        Sets.SetView difference = Sets.difference((Set)colA, (Set)(colB = ImmutableSet.copyOf(inferredColumns)));
        if (!difference.isEmpty()) {
            throw new KsqlException("The following " + (isKey ? "key " : "value ") + "columns are changed, missing or reordered: " + difference + ". Schema from schema registry is " + inferredColumns);
        }
    }

    private static boolean hasKeyElements(ConfiguredStatement<CreateSource> statement) {
        return statement.getStatement().getElements().stream().map(TableElement::getConstraints).anyMatch(c -> c.isKey() || c.isPrimaryKey());
    }

    private static boolean hasValueElements(ConfiguredStatement<CreateSource> statement) {
        return statement.getStatement().getElements().stream().map(TableElement::getConstraints).anyMatch(e -> !e.isKey() && !e.isPrimaryKey() && !e.isHeaders());
    }

    private static boolean formatSupportsSchemaInference(Format format) {
        return format.supportsFeature(SerdeFeature.SCHEMA_INFERENCE);
    }

    private static CreateAsSelect addSchemaFieldsCas(ConfiguredStatement<CreateAsSelect> preparedStatement, Optional<TopicSchemaSupplier.SchemaAndId> keySchema, Optional<TopicSchemaSupplier.SchemaAndId> valueSchema) {
        CreateAsSelect statement = preparedStatement.getStatement();
        CreateSourceAsProperties properties = statement.getProperties();
        Optional<Object> keySchemaName = properties.getKeySchemaId().isPresent() && keySchema.isPresent() ? Optional.ofNullable(keySchema.get().rawSchema.name()) : Optional.empty();
        Optional<Object> valueSchemaName = properties.getValueSchemaId().isPresent() && valueSchema.isPresent() ? Optional.ofNullable(valueSchema.get().rawSchema.name()) : Optional.empty();
        CreateSourceAsProperties newProperties = statement.getProperties().withKeyValueSchemaName(keySchemaName, valueSchemaName);
        return statement.copyWith(newProperties);
    }

    private static void throwOnMultiSchemaDefinitions(ParsedSchema schema, Format schemaFormat, boolean isKey) {
        List schemaFullNames = schemaFormat.schemaFullNames(schema);
        if (schemaFullNames.size() > 1) {
            String schemaFullNameConfig = isKey ? "KEY_SCHEMA_FULL_NAME" : "VALUE_SCHEMA_FULL_NAME";
            throw new KsqlException((isKey ? "Key" : "Value") + " schema has multiple schema definitions. " + System.lineSeparator() + System.lineSeparator() + schemaFullNames.stream().map(n -> "- " + n).collect(Collectors.joining("\n")) + System.lineSeparator() + System.lineSeparator() + "Please specify a schema full name in the WITH clause using " + schemaFullNameConfig);
        }
    }

    private static CreateSource addSchemaFields(ConfiguredStatement<CreateSource> preparedStatement, Optional<TopicSchemaSupplier.SchemaAndId> keySchema, Optional<TopicSchemaSupplier.SchemaAndId> valueSchema) {
        TableElements elements = DefaultSchemaInjector.buildElements(preparedStatement, keySchema, valueSchema);
        CreateSource statement = preparedStatement.getStatement();
        CreateSourceProperties properties = statement.getProperties();
        if (keySchema.isPresent() && !properties.getKeySchemaFullName().isPresent()) {
            Format keyFormat = FormatFactory.of((FormatInfo)SourcePropertiesUtil.getKeyFormat((CreateSourceProperties)properties, (SourceName)statement.getName()));
            DefaultSchemaInjector.throwOnMultiSchemaDefinitions(keySchema.get().rawSchema, keyFormat, true);
        }
        if (valueSchema.isPresent() && !properties.getValueSchemaFullName().isPresent()) {
            Format valueFormat = FormatFactory.of((FormatInfo)SourcePropertiesUtil.getValueFormat((CreateSourceProperties)properties));
            DefaultSchemaInjector.throwOnMultiSchemaDefinitions(valueSchema.get().rawSchema, valueFormat, false);
        }
        Optional<Object> keySchemaName = properties.getKeySchemaFullName().isPresent() ? properties.getKeySchemaFullName() : (properties.getKeySchemaId().isPresent() && keySchema.isPresent() ? Optional.ofNullable(keySchema.get().rawSchema.name()) : Optional.empty());
        Optional<Object> valueSchemaName = properties.getValueSchemaFullName().isPresent() ? properties.getValueSchemaFullName() : (properties.getValueSchemaId().isPresent() && valueSchema.isPresent() ? Optional.ofNullable(valueSchema.get().rawSchema.name()) : Optional.empty());
        CreateSourceProperties newProperties = statement.getProperties().withKeyValueSchemaName(keySchemaName, valueSchemaName);
        return statement.copyWith(elements, newProperties);
    }

    private static TableElements buildElements(ConfiguredStatement<CreateSource> preparedStatement, Optional<TopicSchemaSupplier.SchemaAndId> keySchema, Optional<TopicSchemaSupplier.SchemaAndId> valueSchema) {
        List elements = preparedStatement.getStatement().getElements().stream().filter(tableElement -> tableElement.getConstraints().isHeaders()).collect(Collectors.toList());
        if (keySchema.isPresent()) {
            ColumnConstraints constraints = DefaultSchemaInjector.getKeyConstraints(preparedStatement.getStatement());
            keySchema.get().columns.stream().map(col -> new TableElement(col.name(), new Type(col.type()), constraints)).forEach(elements::add);
        } else {
            DefaultSchemaInjector.getKeyColumns(preparedStatement).forEach(elements::add);
        }
        if (valueSchema.isPresent()) {
            valueSchema.get().columns.stream().map(col -> new TableElement(col.name(), new Type(col.type()))).forEach(elements::add);
        } else {
            DefaultSchemaInjector.getValueColumns(preparedStatement).forEach(elements::add);
        }
        return TableElements.of(elements);
    }

    private static ColumnConstraints getKeyConstraints(CreateSource statement) {
        if (statement instanceof CreateStream) {
            return KEY_CONSTRAINT;
        }
        if (statement instanceof CreateTable) {
            return PRIMARY_KEY_CONSTRAINT;
        }
        throw new IllegalArgumentException("Unrecognized statement type: " + statement);
    }

    private static Stream<TableElement> getKeyColumns(ConfiguredStatement<CreateSource> preparedStatement) {
        return preparedStatement.getStatement().getElements().stream().filter(e -> e.getConstraints().isKey() || e.getConstraints().isPrimaryKey());
    }

    private static Stream<TableElement> getValueColumns(ConfiguredStatement<CreateSource> preparedStatement) {
        return preparedStatement.getStatement().getElements().stream().filter(e -> !e.getConstraints().isKey() && !e.getConstraints().isPrimaryKey() && !e.getConstraints().isHeaders());
    }

    private static <T extends Statement> KsqlParser.PreparedStatement<T> buildPreparedStatement(T stmt) {
        return KsqlParser.PreparedStatement.of((String)SqlFormatter.formatSql(stmt), stmt);
    }
}

