/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.topic;

import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.DefaultTraversalVisitor;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.Table;
import io.confluent.ksql.util.KsqlException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SourceTopicsExtractor
extends DefaultTraversalVisitor<AstNode, Void> {
    private final Set<KsqlTopic> sourceTopics = new HashSet<KsqlTopic>();
    private final MetaStore metaStore;
    private KsqlTopic primarySourceTopic = null;

    public SourceTopicsExtractor(MetaStore metaStore) {
        this.metaStore = metaStore;
    }

    public KsqlTopic getPrimarySourceTopic() {
        return this.primarySourceTopic;
    }

    public Set<KsqlTopic> getSourceTopics() {
        return Collections.unmodifiableSet(this.sourceTopics);
    }

    protected AstNode visitJoin(Join node, Void context) {
        this.process((AstNode)node.getLeft(), context);
        node.getRights().forEach(source -> {
            AstNode cfr_ignored_0 = (AstNode)this.process((AstNode)source.getRelation(), context);
        });
        return null;
    }

    protected AstNode visitAliasedRelation(AliasedRelation node, Void context) {
        SourceName structuredDataSourceName = ((Table)node.getRelation()).getName();
        DataSource source = this.metaStore.getSource(structuredDataSourceName);
        if (source == null) {
            throw new KsqlException(structuredDataSourceName.text() + " does not exist.");
        }
        if (this.primarySourceTopic == null) {
            this.primarySourceTopic = source.getKsqlTopic();
        }
        this.sourceTopics.add(source.getKsqlTopic());
        return node;
    }
}

