/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.topic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.SqlFormatter;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.DropStatement;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.schema.registry.SchemaRegistryUtil;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.util.ExecutorUtil;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class TopicDeleteInjector
implements Injector {
    private final MetaStore metastore;
    private final KafkaTopicClient topicClient;
    private final SchemaRegistryClient schemaRegistryClient;

    public TopicDeleteInjector(KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        this(Objects.requireNonNull(executionContext, "executionContext").getMetaStore(), serviceContext.getTopicClient(), serviceContext.getSchemaRegistryClient());
    }

    @VisibleForTesting
    TopicDeleteInjector(MetaStore metastore, KafkaTopicClient serviceContext, SchemaRegistryClient schemaRegistryClient) {
        this.metastore = Objects.requireNonNull(metastore, "metastore");
        this.topicClient = Objects.requireNonNull(serviceContext, "topicClient");
        this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient, "schemaRegistryClient");
    }

    @Override
    public <T extends Statement> ConfiguredStatement<T> inject(ConfiguredStatement<T> statement) {
        if (!(statement.getStatement() instanceof DropStatement)) {
            return statement;
        }
        DropStatement dropStatement = (DropStatement)statement.getStatement();
        if (!dropStatement.isDeleteTopic()) {
            return statement;
        }
        SourceName sourceName = dropStatement.getName();
        DataSource source = this.metastore.getSource(sourceName);
        if (source != null) {
            if (source.isSource()) {
                throw new KsqlException("Cannot delete topic for read-only source: " + sourceName.text());
            }
            this.checkTopicRefs(source);
            this.deleteTopic(source);
            Closer closer = Closer.create();
            closer.register(() -> this.deleteKeySubject(source));
            closer.register(() -> this.deleteValueSubject(source));
            try {
                closer.close();
            }
            catch (KsqlException e) {
                throw e;
            }
            catch (Exception e) {
                throw new KsqlException((Throwable)e);
            }
        } else if (!dropStatement.getIfExists()) {
            throw new KsqlException("Could not find source to delete topic for: " + statement);
        }
        DropStatement withoutDelete = dropStatement.withoutDeleteClause();
        String withoutDeleteText = SqlFormatter.formatSql((AstNode)withoutDelete) + ";";
        return statement.withStatement(withoutDeleteText, withoutDelete);
    }

    private void deleteTopic(DataSource source) {
        try {
            ExecutorUtil.executeWithRetries(() -> this.topicClient.deleteTopics((Collection)ImmutableList.of((Object)source.getKafkaTopicName())), ExecutorUtil.RetryBehaviour.ALWAYS);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not delete the corresponding kafka topic: " + source.getKafkaTopicName(), e);
        }
    }

    private void deleteKeySubject(DataSource source) {
        try {
            Format keyFormat = FormatFactory.fromName((String)source.getKsqlTopic().getKeyFormat().getFormat());
            if (keyFormat.supportsFeature(SerdeFeature.SCHEMA_INFERENCE)) {
                SchemaRegistryUtil.deleteSubjectWithRetries(this.schemaRegistryClient, KsqlConstants.getSRSubject((String)source.getKafkaTopicName(), (boolean)true));
            }
        }
        catch (Exception e) {
            TopicDeleteInjector.checkSchemaError(e, source.getKafkaTopicName());
        }
    }

    private void deleteValueSubject(DataSource source) {
        try {
            Format valueFormat = FormatFactory.fromName((String)source.getKsqlTopic().getValueFormat().getFormat());
            if (valueFormat.supportsFeature(SerdeFeature.SCHEMA_INFERENCE)) {
                SchemaRegistryUtil.deleteSubjectWithRetries(this.schemaRegistryClient, KsqlConstants.getSRSubject((String)source.getKafkaTopicName(), (boolean)false));
            }
        }
        catch (Exception e) {
            TopicDeleteInjector.checkSchemaError(e, source.getKafkaTopicName());
        }
    }

    private static void checkSchemaError(Exception error, String sourceName) {
        if (!SchemaRegistryUtil.isSubjectNotFoundErrorCode(error)) {
            throw new RuntimeException("Could not clean up the schema registry for topic: " + sourceName, error);
        }
    }

    private void checkTopicRefs(DataSource source) {
        String topicName = source.getKafkaTopicName();
        SourceName sourceName = source.getName();
        Map sources = this.metastore.getAllDataSources();
        String using = sources.values().stream().filter(s -> s.getKafkaTopicName().equals(topicName)).map(DataSource::getName).filter(name -> !sourceName.equals(name)).map(Name::text).sorted().collect(Collectors.joining(", "));
        if (!using.isEmpty()) {
            throw new RuntimeException(String.format("Refusing to delete topic. Found other data sources (%s) using topic %s", using, topicName));
        }
    }
}

