/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import com.google.errorprone.annotations.Immutable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class LimitedProxyBuilder<T> {
    private static final MethodParams ANY_PARAMS = LimitedProxyBuilder.methodParams(AllVariants.class);
    private static final MethodParams NO_PARAMS = LimitedProxyBuilder.methodParams(new Class[0]);
    private static final InvocationHandler SWALLOW = (proxy, method, args) -> null;
    private final Class<T> type;
    private final Map<Method, InvocationHandler> handledMethods = new HashMap<Method, InvocationHandler>();

    public static <T> LimitedProxyBuilder<T> forClass(Class<T> type) {
        return new LimitedProxyBuilder<T>(type);
    }

    public LimitedProxyBuilder<T> swallow(String methodName, MethodParams methodParams) {
        Collection<Method> methods = this.getDeclaredPublicMethods(methodName, methodParams);
        LimitedProxyBuilder.throwOnNoneVoidReturnType(methods);
        methods.forEach(method -> this.handledMethods.put((Method)method, LimitedProxyBuilder.buildSwallower(method, null)));
        return this;
    }

    public LimitedProxyBuilder<T> swallow(String methodName, MethodParams methodParams, Object returnValue) {
        Collection<Method> methods = this.getDeclaredPublicMethods(methodName, methodParams);
        methods.forEach(method -> this.handledMethods.put((Method)method, LimitedProxyBuilder.buildSwallower(method, returnValue)));
        return this;
    }

    public LimitedProxyBuilder<T> forward(String methodName, MethodParams methodParams, Object delegate) {
        Collection<Method> methods = this.getDeclaredPublicMethods(methodName, methodParams);
        methods.forEach(method -> this.handledMethods.put((Method)method, this.buildForwader(delegate, (Method)method)));
        return this;
    }

    public <TT extends T> TT build() {
        return (TT)Proxy.newProxyInstance(LimitedProxyBuilder.class.getClassLoader(), new Class[]{this.type}, (InvocationHandler)new SandboxProxy(this.handledMethods));
    }

    public static MethodParams methodParams(Class<?> ... params) {
        return new MethodParams(params);
    }

    public static MethodParams noParams() {
        return NO_PARAMS;
    }

    public static MethodParams anyParams() {
        return ANY_PARAMS;
    }

    private LimitedProxyBuilder(Class<T> type) {
        this.type = Objects.requireNonNull(type, "type");
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Type not an interface: " + type);
        }
    }

    private Collection<Method> getDeclaredPublicMethods(String methodName, MethodParams methodParams) {
        boolean allVariants = methodParams.equals(ANY_PARAMS);
        List<Method> matching = Arrays.stream(this.type.getDeclaredMethods()).filter(m -> m.getName().equals(methodName)).filter(m -> allVariants || methodParams.matches(m.getParameterTypes())).collect(Collectors.toList());
        if (matching.isEmpty()) {
            throw new IllegalArgumentException("Interface '" + this.type.getSimpleName() + "' does not have method: " + methodName + "(" + methodParams + ")");
        }
        this.throwIfAlreadyRegistered(matching);
        return matching;
    }

    private static InvocationHandler buildSwallower(Method method, Object returnValue) {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            if (returnValue != null) {
                throw new IllegalArgumentException("Can not provide a default value for void method: " + LimitedProxyBuilder.formatMethod(method));
            }
            return SWALLOW;
        }
        if (returnValue != null && !Primitives.unwrap(returnValue.getClass()).equals(Primitives.unwrap(returnType)) && !returnType.isAssignableFrom(returnValue.getClass())) {
            throw new IllegalArgumentException("Supplied return value is not of type " + returnType.getSimpleName());
        }
        return (proxy, m, args) -> returnValue;
    }

    private InvocationHandler buildForwader(Object delegate, Method proxyMethod) {
        if (this.type.isAssignableFrom(delegate.getClass())) {
            return (proxy, m, args) -> m.invoke(delegate, args);
        }
        Method declaredMethod = LimitedProxyBuilder.findMatchingMethod(delegate, proxyMethod);
        return (proxy, m, args) -> declaredMethod.invoke(delegate, args);
    }

    private void throwIfAlreadyRegistered(Collection<Method> methods) {
        String duplicates = methods.stream().filter(this.handledMethods::containsKey).map(LimitedProxyBuilder::formatMethod).collect(Collectors.joining(System.lineSeparator()));
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("method(s) already registered: " + System.lineSeparator() + duplicates);
        }
    }

    private static void throwOnNoneVoidReturnType(Collection<Method> methods) {
        String noneVoid = methods.stream().filter(method -> !method.getReturnType().equals(Void.TYPE)).map(LimitedProxyBuilder::formatMethod).collect(Collectors.joining(System.lineSeparator()));
        if (!noneVoid.isEmpty()) {
            throw new IllegalArgumentException("Can only swallow void methods. None void methods: " + System.lineSeparator() + noneVoid);
        }
    }

    private static Method findMatchingMethod(Object delegate, Method proxyMethod) {
        try {
            Method declaredMethod = delegate.getClass().getDeclaredMethod(proxyMethod.getName(), proxyMethod.getParameterTypes());
            if (!declaredMethod.getReturnType().equals(proxyMethod.getReturnType())) {
                throw new IllegalArgumentException("Delegate's method has different return type. wanted:" + proxyMethod.getReturnType() + ", got:" + declaredMethod.getReturnType());
            }
            if (!declaredMethod.isAccessible()) {
                declaredMethod.setAccessible(true);
            }
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Delegate does not have method: " + LimitedProxyBuilder.formatMethod(proxyMethod), e);
        }
    }

    private static String formatMethod(Method method) {
        String params = Arrays.stream(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(","));
        return method.getReturnType().getSimpleName() + " " + method.getName() + "(" + params + ")";
    }

    @Immutable
    static final class MethodParams {
        private final ImmutableList<Class<?>> paramTypes;

        MethodParams(Class<?> ... params) {
            this.paramTypes = MethodParams.asList(params);
        }

        public boolean matches(Class<?>[] argTypes) {
            return MethodParams.asList(argTypes).equals(this.paramTypes);
        }

        public String toString() {
            if (this == ANY_PARAMS) {
                return "*";
            }
            return this.paramTypes.stream().map(Class::getSimpleName).collect(Collectors.joining(","));
        }

        private static ImmutableList<Class<?>> asList(Class<?>[] params) {
            return ImmutableList.builder().add((Object[])params).build();
        }
    }

    private static final class AllVariants {
        private AllVariants() {
        }
    }

    private static final class SandboxProxy
    implements InvocationHandler {
        private final Map<Method, InvocationHandler> handledMethods;

        private SandboxProxy(Map<Method, InvocationHandler> handledMethods) {
            this.handledMethods = ImmutableMap.copyOf(handledMethods);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            InvocationHandler handler = this.handledMethods.get(method);
            if (handler == null) {
                throw new UnsupportedOperationException(LimitedProxyBuilder.formatMethod(method));
            }
            try {
                return handler.invoke(proxy, method, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause() == null ? e : e.getCause();
            }
        }
    }
}

