/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.context.QueryLoggerUtil;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ForeignKeyTableTableJoin;
import io.confluent.ksql.execution.plan.SourceStep;
import io.confluent.ksql.execution.plan.StreamAggregate;
import io.confluent.ksql.execution.plan.StreamFilter;
import io.confluent.ksql.execution.plan.StreamFlatMap;
import io.confluent.ksql.execution.plan.StreamGroupBy;
import io.confluent.ksql.execution.plan.StreamGroupByKey;
import io.confluent.ksql.execution.plan.StreamGroupByV1;
import io.confluent.ksql.execution.plan.StreamSelect;
import io.confluent.ksql.execution.plan.StreamSelectKey;
import io.confluent.ksql.execution.plan.StreamSelectKeyV1;
import io.confluent.ksql.execution.plan.StreamSink;
import io.confluent.ksql.execution.plan.StreamSource;
import io.confluent.ksql.execution.plan.StreamStreamJoin;
import io.confluent.ksql.execution.plan.StreamTableJoin;
import io.confluent.ksql.execution.plan.StreamWindowedAggregate;
import io.confluent.ksql.execution.plan.TableAggregate;
import io.confluent.ksql.execution.plan.TableFilter;
import io.confluent.ksql.execution.plan.TableGroupBy;
import io.confluent.ksql.execution.plan.TableGroupByV1;
import io.confluent.ksql.execution.plan.TableSelect;
import io.confluent.ksql.execution.plan.TableSelectKey;
import io.confluent.ksql.execution.plan.TableSink;
import io.confluent.ksql.execution.plan.TableSource;
import io.confluent.ksql.execution.plan.TableSourceV1;
import io.confluent.ksql.execution.plan.TableSuppress;
import io.confluent.ksql.execution.plan.TableTableJoin;
import io.confluent.ksql.execution.plan.WindowedStreamSource;
import io.confluent.ksql.execution.plan.WindowedTableSource;
import io.confluent.ksql.execution.streams.StepSchemaResolver;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.util.IdentifierUtil;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PlanSummary {
    private static final FormatOptions FORMAT_OPTIONS = FormatOptions.of(IdentifierUtil::needsQuotes);
    private static final Map<Class<? extends ExecutionStep>, String> OP_NAME = new ImmutableMap.Builder().put(StreamAggregate.class, (Object)"AGGREGATE").put(StreamWindowedAggregate.class, (Object)"AGGREGATE").put(StreamFilter.class, (Object)"FILTER").put(StreamFlatMap.class, (Object)"FLAT_MAP").put(StreamGroupByV1.class, (Object)"GROUP_BY").put(StreamGroupBy.class, (Object)"GROUP_BY").put(StreamGroupByKey.class, (Object)"GROUP_BY").put(StreamSelect.class, (Object)"PROJECT").put(StreamSelectKeyV1.class, (Object)"REKEY").put(StreamSelectKey.class, (Object)"REKEY").put(StreamSink.class, (Object)"SINK").put(StreamSource.class, (Object)"SOURCE").put(StreamStreamJoin.class, (Object)"JOIN").put(StreamTableJoin.class, (Object)"JOIN").put(WindowedStreamSource.class, (Object)"SOURCE").put(TableAggregate.class, (Object)"AGGREGATE").put(TableFilter.class, (Object)"FILTER").put(TableGroupByV1.class, (Object)"GROUP_BY").put(TableGroupBy.class, (Object)"GROUP_BY").put(TableSelect.class, (Object)"PROJECT").put(TableSelectKey.class, (Object)"REKEY").put(TableSink.class, (Object)"SINK").put(TableTableJoin.class, (Object)"JOIN").put(ForeignKeyTableTableJoin.class, (Object)"JOIN").put(TableSourceV1.class, (Object)"SOURCE").put(TableSource.class, (Object)"SOURCE").put(TableSuppress.class, (Object)"SUPPRESS").put(WindowedTableSource.class, (Object)"SOURCE").build();
    private final QueryId queryId;
    private final StepSchemaResolver schemaResolver;

    public PlanSummary(QueryId queryId, KsqlConfig config, MetaStore metaStore) {
        this(queryId, new StepSchemaResolver(config, (FunctionRegistry)metaStore));
    }

    @VisibleForTesting
    PlanSummary(QueryId queryId, StepSchemaResolver schemaResolver) {
        this.queryId = Objects.requireNonNull(queryId, "queryId");
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
    }

    public String summarize(ExecutionStep<?> step) {
        return this.summarize(step, "").summary;
    }

    private StepSummary summarize(ExecutionStep<?> step, String indent) {
        StringBuilder stringBuilder = new StringBuilder();
        List<StepSummary> sourceSummaries = step.getSources().stream().map(s -> this.summarize((ExecutionStep<?>)s, indent + "\t")).collect(Collectors.toList());
        String opName = OP_NAME.get(step.getClass());
        if (opName == null) {
            throw new UnsupportedOperationException("Unsupported step type: " + step.getClass() + ", please add a step type");
        }
        LogicalSchema schema = this.getSchema(step, sourceSummaries);
        stringBuilder.append(indent).append(" > [ ").append(opName).append(" ] | Schema: ").append(schema.toString(FORMAT_OPTIONS)).append(" | Logger: ").append(QueryLoggerUtil.queryLoggerName((QueryId)this.queryId, (QueryContext)step.getProperties().getQueryContext())).append("\n");
        for (StepSummary sourceSummary : sourceSummaries) {
            stringBuilder.append("\t").append(indent).append(sourceSummary.summary);
        }
        return new StepSummary(schema, stringBuilder.toString());
    }

    private LogicalSchema getSchema(ExecutionStep<?> step, List<StepSummary> sourceSummaries) {
        switch (sourceSummaries.size()) {
            case 1: {
                return this.schemaResolver.resolve(step, sourceSummaries.get(0).schema);
            }
            case 2: {
                return this.schemaResolver.resolve(step, sourceSummaries.get(0).schema, sourceSummaries.get(1).schema);
            }
            case 0: {
                return this.schemaResolver.resolve(step, ((SourceStep)step).getSourceSchema());
            }
        }
        throw new IllegalStateException();
    }

    private static final class StepSummary {
        private final LogicalSchema schema;
        private final String summary;

        private StepSummary(LogicalSchema schema, String summary) {
            this.schema = Objects.requireNonNull(schema, "schema");
            this.summary = Objects.requireNonNull(summary, "summary");
        }
    }
}

