/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.ProcessingLoggerFactory;
import io.confluent.ksql.logging.query.QueryLogger;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.query.KafkaStreamsBuilder;
import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryErrorClassifier;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.entity.StreamsTaskMetadata;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.QueryMetadata;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.LagInfo;
import org.apache.kafka.streams.StreamsMetadata;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryMetadataImpl
implements QueryMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(QueryMetadataImpl.class);
    private final AtomicBoolean isPaused = new AtomicBoolean(false);
    private final String statementString;
    private final String executionPlan;
    private final String queryApplicationId;
    private final Topology topology;
    private final KafkaStreamsBuilder kafkaStreamsBuilder;
    private final ImmutableMap<String, Object> streamsProperties;
    private final ImmutableMap<String, Object> overriddenProperties;
    private final ImmutableSet<SourceName> sourceNames;
    private final LogicalSchema logicalSchema;
    private final Duration closeTimeout;
    private final QueryId queryId;
    private final QueryErrorClassifier errorClassifier;
    private final TimeBoundedQueue queryErrors;
    private final RetryEvent retryEvent;
    private final QueryMetadata.Listener listener;
    private final ProcessingLoggerFactory loggerFactory;
    private volatile boolean everStarted = false;
    private volatile KafkaStreams kafkaStreams;
    private boolean initialized = false;
    private boolean corruptionCommandTopic = false;
    private static final Ticker CURRENT_TIME_MILLIS_TICKER = new Ticker(){

        public long read() {
            return System.currentTimeMillis();
        }
    };

    @VisibleForTesting
    QueryMetadataImpl(String statementString, LogicalSchema logicalSchema, Set<SourceName> sourceNames, String executionPlan, String queryApplicationId, Topology topology, KafkaStreamsBuilder kafkaStreamsBuilder, Map<String, Object> streamsProperties, Map<String, Object> overriddenProperties, long closeTimeout, QueryId queryId, QueryErrorClassifier errorClassifier, int maxQueryErrorsQueueSize, long baseWaitingTimeMs, long retryBackoffMaxMs, QueryMetadata.Listener listener, ProcessingLoggerFactory loggerFactory) {
        this.statementString = Objects.requireNonNull(statementString, "statementString");
        this.executionPlan = Objects.requireNonNull(executionPlan, "executionPlan");
        this.queryApplicationId = Objects.requireNonNull(queryApplicationId, "queryApplicationId");
        this.topology = Objects.requireNonNull(topology, "kafkaTopicClient");
        this.kafkaStreamsBuilder = Objects.requireNonNull(kafkaStreamsBuilder, "kafkaStreamsBuilder");
        this.streamsProperties = ImmutableMap.copyOf(Objects.requireNonNull(streamsProperties, "streamsPropeties"));
        this.overriddenProperties = ImmutableMap.copyOf(Objects.requireNonNull(overriddenProperties, "overriddenProperties"));
        this.listener = Objects.requireNonNull(listener, "listener");
        this.sourceNames = ImmutableSet.copyOf((Collection)Objects.requireNonNull(sourceNames, "sourceNames"));
        this.logicalSchema = Objects.requireNonNull(logicalSchema, "logicalSchema");
        this.closeTimeout = Duration.ofMillis(closeTimeout);
        this.queryId = Objects.requireNonNull(queryId, "queryId");
        this.errorClassifier = Objects.requireNonNull(errorClassifier, "errorClassifier");
        this.queryErrors = new TimeBoundedQueue(Duration.ofHours(1L), maxQueryErrorsQueueSize);
        this.retryEvent = new RetryEvent(queryId, baseWaitingTimeMs, retryBackoffMaxMs, CURRENT_TIME_MILLIS_TICKER);
        this.loggerFactory = Objects.requireNonNull(loggerFactory, "loggerFactory");
    }

    QueryMetadataImpl(QueryMetadataImpl other, QueryMetadata.Listener listener) {
        this.statementString = other.getStatementString();
        this.kafkaStreams = other.getKafkaStreams();
        this.executionPlan = other.getExecutionPlan();
        this.queryApplicationId = other.getQueryApplicationId();
        this.topology = other.getTopology();
        this.kafkaStreamsBuilder = other.kafkaStreamsBuilder;
        this.streamsProperties = other.getStreamsProperties();
        this.overriddenProperties = other.getOverriddenProperties();
        this.sourceNames = other.getSourceNames();
        this.logicalSchema = other.getLogicalSchema();
        this.closeTimeout = other.closeTimeout;
        this.queryId = other.getQueryId();
        this.errorClassifier = other.errorClassifier;
        this.everStarted = other.everStarted;
        this.queryErrors = new TimeBoundedQueue(Duration.ZERO, 0);
        this.retryEvent = new RetryEvent(other.getQueryId(), 0L, 0L, new Ticker(){

            public long read() {
                return 0L;
            }
        });
        this.listener = Objects.requireNonNull(listener, "stopListeners");
        this.loggerFactory = other.loggerFactory;
    }

    @Override
    public void initialize() {
        this.resetKafkaStreams(this.kafkaStreamsBuilder.build(this.topology, (Map<String, Object>)this.streamsProperties));
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse uncaughtHandler(Throwable e) {
        QueryError.Type errorType = QueryError.Type.UNKNOWN;
        try {
            QueryLogger.error((Object)String.format("Uncaught exception in query %s", e), this.statementString);
            errorType = this.causalChainClassification(e);
        }
        catch (Exception classificationException) {
            try {
                LOG.error("Error classifying unhandled exception", (Throwable)classificationException);
            }
            catch (Throwable throwable) {
                QueryError queryError = new QueryError(System.currentTimeMillis(), Throwables.getStackTraceAsString((Throwable)e), errorType);
                this.listener.onError(this, queryError);
                this.queryErrors.add(queryError);
                LOG.error("Unhandled exception caught in streams thread {}. ({})", new Object[]{Thread.currentThread().getName(), errorType, e});
                throw throwable;
            }
            QueryError queryError = new QueryError(System.currentTimeMillis(), Throwables.getStackTraceAsString((Throwable)e), errorType);
            this.listener.onError(this, queryError);
            this.queryErrors.add(queryError);
            LOG.error("Unhandled exception caught in streams thread {}. ({})", new Object[]{Thread.currentThread().getName(), errorType, e});
        }
        QueryError queryError = new QueryError(System.currentTimeMillis(), Throwables.getStackTraceAsString((Throwable)e), errorType);
        this.listener.onError(this, queryError);
        this.queryErrors.add(queryError);
        LOG.error("Unhandled exception caught in streams thread {}. ({})", new Object[]{Thread.currentThread().getName(), errorType, e});
        this.retryEvent.backOff(Thread.currentThread().getName());
        return StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse.REPLACE_THREAD;
    }

    @Override
    public Set<StreamsTaskMetadata> getTaskMetadata() {
        return this.kafkaStreams.metadataForLocalThreads().stream().flatMap(t -> t.activeTasks().stream()).map(StreamsTaskMetadata::fromStreamsTaskMetadata).collect(Collectors.toSet());
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="overriddenProperties is ImmutableMap")
    public ImmutableMap<String, Object> getOverriddenProperties() {
        return this.overriddenProperties;
    }

    @Override
    public String getStatementString() {
        return this.statementString;
    }

    @Override
    public void setUncaughtExceptionHandler(StreamsUncaughtExceptionHandler handler) {
        this.kafkaStreams.setUncaughtExceptionHandler(handler);
    }

    @Override
    public KafkaStreams.State getState() {
        if (this.corruptionCommandTopic) {
            return KafkaStreams.State.ERROR;
        }
        return this.kafkaStreams.state();
    }

    @Override
    public String getExecutionPlan() {
        return this.executionPlan;
    }

    @Override
    public String getQueryApplicationId() {
        return this.queryApplicationId;
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public Map<String, Map<Integer, LagInfo>> getAllLocalStorePartitionLags() {
        try {
            return this.kafkaStreams.allLocalStorePartitionLags();
        }
        catch (IllegalStateException | StreamsException e) {
            LOG.error(e.getMessage());
            return ImmutableMap.of();
        }
    }

    @Override
    public Collection<StreamsMetadata> getAllStreamsHostMetadata() {
        try {
            return ImmutableList.copyOf((Collection)this.kafkaStreams.metadataForAllStreamsClients());
        }
        catch (IllegalStateException e) {
            LOG.error(e.getMessage());
            return ImmutableList.of();
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="streamsProperties is ImmutableMap")
    public ImmutableMap<String, Object> getStreamsProperties() {
        return this.streamsProperties;
    }

    @Override
    public LogicalSchema getLogicalSchema() {
        return this.logicalSchema;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="sourceNames is ImmutableSet")
    public ImmutableSet<SourceName> getSourceNames() {
        return this.sourceNames;
    }

    @Override
    public boolean hasEverBeenStarted() {
        return this.everStarted;
    }

    @Override
    public QueryId getQueryId() {
        return this.queryId;
    }

    @Override
    public KsqlConstants.KsqlQueryType getQueryType() {
        return KsqlConstants.KsqlQueryType.PERSISTENT;
    }

    @Override
    public String getTopologyDescription() {
        return this.topology.describe().toString();
    }

    @Override
    public List<QueryError> getQueryErrors() {
        return this.queryErrors.toImmutableList();
    }

    @Override
    public void setCorruptionQueryError() {
        QueryError corruptionQueryError = new QueryError(System.currentTimeMillis(), "Query not started due to corruption in the command topic.", QueryError.Type.USER);
        this.listener.onError(this, corruptionQueryError);
        this.queryErrors.add(corruptionQueryError);
        this.corruptionCommandTopic = true;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public KafkaStreams getKafkaStreams() {
        return this.kafkaStreams;
    }

    QueryMetadata.Listener getListener() {
        return this.listener;
    }

    private void resetKafkaStreams(KafkaStreams kafkaStreams) {
        this.kafkaStreams = kafkaStreams;
        this.setUncaughtExceptionHandler(this::uncaughtHandler);
        kafkaStreams.setStateListener((b, a) -> this.listener.onStateChange(this, b, a));
    }

    protected boolean closeKafkaStreams() {
        if (this.initialized) {
            this.kafkaStreams.close(this.closeTimeout);
            if (!this.getState().equals((Object)KafkaStreams.State.NOT_RUNNING)) {
                LOG.warn("query has not terminated even after close. This may happen when streams threads are hung. State: " + this.getState());
                return false;
            }
        }
        return true;
    }

    @Override
    public void close() {
        this.loggerFactory.getLoggersWithPrefix(this.queryId.toString()).forEach(ProcessingLogger::close);
        this.doClose(true);
        this.listener.onClose(this);
    }

    void doClose(boolean cleanUp) {
        boolean closedKafkaStreams = this.closeKafkaStreams();
        if (cleanUp && closedKafkaStreams) {
            this.kafkaStreams.cleanUp();
        } else if (!closedKafkaStreams) {
            LOG.warn("Query has not successfully closed, skipping cleanup");
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void start() {
        if (!this.initialized) {
            throw new KsqlException(String.format("Failed to initialize query %s before starting it", this.queryApplicationId));
        }
        LOG.info("Starting query with application id: {}", (Object)this.queryApplicationId);
        this.everStarted = true;
        this.listener.onStateChange(this, this.kafkaStreams.state(), this.kafkaStreams.state());
        this.kafkaStreams.start();
    }

    @Override
    public KsqlConstants.KsqlQueryStatus getQueryStatus() {
        if (this.isPaused.get()) {
            return KsqlConstants.KsqlQueryStatus.PAUSED;
        }
        return KsqlConstants.fromStreamsState((KafkaStreams.State)this.getState());
    }

    @Override
    public void pause() {
        this.kafkaStreams.pause();
        this.isPaused.set(true);
        this.listener.onPause(this);
    }

    @Override
    public void resume() {
        this.kafkaStreams.resume();
        this.isPaused.set(false);
        this.listener.onResume(this);
    }

    private QueryError.Type causalChainClassification(Throwable throwable) {
        for (Throwable t : Throwables.getCausalChain((Throwable)throwable)) {
            QueryError.Type errorType = this.errorClassifier.classify(t);
            if (errorType == QueryError.Type.UNKNOWN) continue;
            return errorType;
        }
        return QueryError.Type.UNKNOWN;
    }

    public static class RetryEvent
    implements QueryMetadata.RetryEvent {
        private final Ticker ticker;
        private final QueryId queryId;
        private Map<String, Integer> numRetries = new ConcurrentHashMap<String, Integer>();
        private long waitingTimeMs;
        private long expiryTimeMs;
        private long retryBackoffMaxMs;

        RetryEvent(QueryId queryId, long baseWaitingTimeMs, long retryBackoffMaxMs, Ticker ticker) {
            this.ticker = ticker;
            this.queryId = queryId;
            long now = ticker.read();
            this.waitingTimeMs = baseWaitingTimeMs;
            this.retryBackoffMaxMs = retryBackoffMaxMs;
            this.expiryTimeMs = now + baseWaitingTimeMs;
        }

        @Override
        public long nextRestartTimeMs() {
            return this.expiryTimeMs;
        }

        @Override
        public int getNumRetries(String threadName) {
            return this.numRetries.getOrDefault(threadName, 0);
        }

        @Override
        public void backOff(String threadName) {
            long now = this.ticker.read();
            this.waitingTimeMs = this.getWaitingTimeMs();
            try {
                Thread.sleep(this.waitingTimeMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            int retries = this.numRetries.merge(threadName, 1, Integer::sum);
            LOG.info("Restarting query {} thread {} (attempt #{})", new Object[]{this.queryId, threadName, retries});
            this.expiryTimeMs = Math.max(now, now + this.waitingTimeMs);
        }

        private long getWaitingTimeMs() {
            if (this.waitingTimeMs * 2L < this.retryBackoffMaxMs) {
                return this.waitingTimeMs * 2L;
            }
            return this.retryBackoffMaxMs;
        }
    }

    public static class TimeBoundedQueue {
        private final Duration duration;
        private final Queue<QueryError> queue;

        TimeBoundedQueue(Duration duration, int capacity) {
            this.queue = new ConcurrentLinkedQueue<QueryError>((Collection<QueryError>)EvictingQueue.create((int)capacity));
            this.duration = duration;
        }

        public void add(QueryError e) {
            this.queue.add(e);
            this.evict();
        }

        public List<QueryError> toImmutableList() {
            this.evict();
            return ImmutableList.copyOf(this.queue);
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        private void evict() {
            while (!this.queue.isEmpty() && this.queue.peek().getTimestamp() <= System.currentTimeMillis() - this.duration.toMillis()) {
                this.queue.poll();
            }
        }
    }
}

