/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.scalablepush.PushQueryPreparer;
import io.confluent.ksql.execution.scalablepush.PushQueryQueuePopulator;
import io.confluent.ksql.execution.scalablepush.PushRouting;
import io.confluent.ksql.internal.ScalablePushQueryMetrics;
import io.confluent.ksql.query.CompletionHandler;
import io.confluent.ksql.query.LimitHandler;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.query.TransientQueryQueue;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.PushQueryMetadata;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;

public class ScalablePushQueryMetadata
implements PushQueryMetadata {
    private volatile boolean closed = false;
    private final LogicalSchema logicalSchema;
    private final QueryId queryId;
    private final TransientQueryQueue transientQueryQueue;
    private final Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics;
    private final PushQueryMetadata.ResultType resultType;
    private final PushQueryQueuePopulator pushQueryQueuePopulator;
    private final PushQueryPreparer pushQueryPreparer;
    private final KsqlConstants.QuerySourceType sourceType;
    private final KsqlConstants.RoutingNodeType routingNodeType;
    private final Supplier<Long> rowsProcessedSupplier;
    private CompletableFuture<PushRouting.PushConnectionsHandle> startFuture = new CompletableFuture();
    private CompletableFuture<Void> runningFuture = new CompletableFuture();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ScalablePushQueryMetadata(LogicalSchema logicalSchema, QueryId queryId, TransientQueryQueue transientQueryQueue, Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics, PushQueryMetadata.ResultType resultType, PushQueryQueuePopulator pushQueryQueuePopulator, PushQueryPreparer pushQueryPreparer, KsqlConstants.QuerySourceType sourceType, KsqlConstants.RoutingNodeType routingNodeType, Supplier<Long> rowsProcessedSupplier) {
        this.logicalSchema = logicalSchema;
        this.queryId = queryId;
        this.transientQueryQueue = transientQueryQueue;
        this.scalablePushQueryMetrics = scalablePushQueryMetrics;
        this.resultType = resultType;
        this.pushQueryQueuePopulator = pushQueryQueuePopulator;
        this.pushQueryPreparer = pushQueryPreparer;
        this.sourceType = sourceType;
        this.routingNodeType = routingNodeType;
        this.rowsProcessedSupplier = rowsProcessedSupplier;
    }

    public void prepare() {
        this.pushQueryPreparer.prepare();
    }

    @Override
    public void start() {
        ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(v -> this.pushQueryQueuePopulator.run())).thenApply(handle -> {
            this.startFuture.complete((PushRouting.PushConnectionsHandle)handle);
            handle.onException(this.runningFuture::completeExceptionally);
            return null;
        })).exceptionally(t -> {
            this.startFuture.completeExceptionally((Throwable)t);
            this.runningFuture.completeExceptionally((Throwable)t);
            return null;
        });
    }

    @Override
    public void close() {
        this.transientQueryQueue.close();
        this.startFuture.thenApply(handle -> {
            handle.close();
            return null;
        });
        this.closed = true;
    }

    @Override
    public boolean isRunning() {
        return !this.closed;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public TransientQueryQueue getRowQueue() {
        return this.transientQueryQueue;
    }

    @Override
    public void setLimitHandler(LimitHandler limitHandler) {
        this.transientQueryQueue.setLimitHandler(limitHandler);
    }

    @Override
    public void setCompletionHandler(CompletionHandler completionHandler) {
        this.transientQueryQueue.setCompletionHandler(completionHandler);
    }

    @Override
    public void setUncaughtExceptionHandler(StreamsUncaughtExceptionHandler handler) {
        this.onException(arg_0 -> ((StreamsUncaughtExceptionHandler)handler).handle(arg_0));
    }

    @Override
    public LogicalSchema getLogicalSchema() {
        return this.logicalSchema;
    }

    @Override
    public QueryId getQueryId() {
        return this.queryId;
    }

    @Override
    public PushQueryMetadata.ResultType getResultType() {
        return this.resultType;
    }

    public void onException(Consumer<Throwable> consumer) {
        this.runningFuture.exceptionally(t -> {
            this.scalablePushQueryMetrics.ifPresent(metrics -> metrics.recordErrorRate(1.0, this.sourceType, this.routingNodeType));
            consumer.accept((Throwable)t);
            return null;
        });
    }

    public void onCompletion(Consumer<Void> consumer) {
        this.runningFuture.thenAccept((Consumer)consumer);
    }

    public void onCompletionOrException(BiConsumer<Void, Throwable> biConsumer) {
        this.runningFuture.handle((v, t) -> {
            biConsumer.accept((Void)v, (Throwable)t);
            return null;
        });
    }

    public KsqlConstants.QuerySourceType getSourceType() {
        return this.sourceType;
    }

    public KsqlConstants.RoutingNodeType getRoutingNodeType() {
        return this.routingNodeType;
    }

    public long getTotalRowsReturned() {
        return this.transientQueryQueue.getTotalRowsQueued();
    }

    public long getTotalRowsProcessed() {
        return this.rowsProcessedSupplier.get();
    }
}

